/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.conditions;

import ch.njol.skript.command.Commands;
import ch.njol.skript.conditions.base.PropertyCondition;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;

@Name(value="Is a Skript command")
@Description(value={"Checks whether a command/string is a custom Skript command."})
@Examples(value={"# Example 1", "on command:", "\tcommand is a skript command", "", "# Example 2", "\"sometext\" is a skript command"})
@Since(value={"2.6"})
public class CondIsSkriptCommand
extends PropertyCondition<String> {
    @Override
    public boolean check(String cmd) {
        return Commands.scriptCommandExists(cmd);
    }

    @Override
    protected String getPropertyName() {
        return "skript command";
    }

    static {
        CondIsSkriptCommand.register(CondIsSkriptCommand.class, "[a] s(k|c)ript (command|cmd)", "string");
    }
}

