/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.conditions;

import ch.njol.skript.conditions.base.PropertyCondition;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import org.bukkit.inventory.ItemStack;

@Name(value="Is Stackable")
@Description(value={"Checks whether an item is stackable."})
@Examples(value={"diamond axe is stackable", "birch wood is stackable", "torch is stackable"})
@Since(value={"2.7"})
public class CondIsStackable
extends PropertyCondition<ItemStack> {
    @Override
    public boolean check(ItemStack item) {
        return item.getMaxStackSize() > 1;
    }

    @Override
    protected String getPropertyName() {
        return "stackable";
    }

    static {
        CondIsStackable.register(CondIsStackable.class, "stackable", "itemstacks");
    }
}

