/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.doc;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Documentation;
import ch.njol.skript.doc.DocumentationGenerator;
import ch.njol.skript.doc.DocumentationIdProvider;
import ch.njol.skript.doc.Events;
import ch.njol.skript.doc.Example;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Keywords;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.NoDoc;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.SkriptEventInfo;
import ch.njol.skript.lang.SyntaxElement;
import ch.njol.skript.lang.SyntaxElementInfo;
import ch.njol.skript.lang.function.Functions;
import ch.njol.skript.lang.function.JavaFunction;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.registrations.EventValues;
import ch.njol.skript.util.Version;
import com.google.common.collect.Multimap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockCanBuildEvent;
import org.jetbrains.annotations.NotNull;
import org.skriptlang.skript.lang.structure.Structure;
import org.skriptlang.skript.lang.structure.StructureInfo;

public class JSONGenerator
extends DocumentationGenerator {
    public static final Version JSON_VERSION = new Version(1, 1);
    private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().serializeNulls().create();

    public JSONGenerator(File templateDir, File outputDir) {
        super(templateDir, outputDir);
    }

    private static JsonObject getVersion() {
        JsonObject version = new JsonObject();
        version.addProperty("major", (Number)JSON_VERSION.getMajor());
        version.addProperty("minor", (Number)JSON_VERSION.getMinor());
        return version;
    }

    private static JsonArray convertToJsonArray(String ... strings) {
        if (strings == null || strings.length == 0) {
            return null;
        }
        JsonArray jsonArray = new JsonArray();
        for (String string : strings) {
            jsonArray.add((JsonElement)new JsonPrimitive(string));
        }
        return jsonArray;
    }

    private static JsonObject generatedAnnotatedElement(SyntaxElementInfo<?> syntaxInfo) {
        Class<?> syntaxClass = syntaxInfo.getElementClass();
        Name name = syntaxClass.getAnnotation(Name.class);
        if (name == null || syntaxClass.getAnnotation(NoDoc.class) != null) {
            return null;
        }
        JsonObject syntaxJsonObject = new JsonObject();
        syntaxJsonObject.addProperty("id", DocumentationIdProvider.getId(syntaxInfo));
        syntaxJsonObject.addProperty("name", name.value());
        Since since = syntaxClass.getAnnotation(Since.class);
        syntaxJsonObject.add("since", since == null ? null : JSONGenerator.convertToJsonArray(since.value()));
        Deprecated deprecated = syntaxClass.getAnnotation(Deprecated.class);
        syntaxJsonObject.addProperty("deprecated", Boolean.valueOf(deprecated != null));
        Description description = syntaxClass.getAnnotation(Description.class);
        syntaxJsonObject.add("description", description == null ? null : JSONGenerator.convertToJsonArray(description.value()));
        syntaxJsonObject.add("patterns", (JsonElement)JSONGenerator.cleanPatterns(syntaxInfo.getPatterns()));
        if (syntaxClass.isAnnotationPresent(Examples.class)) {
            examplesAnnotation = syntaxClass.getAnnotation(Examples.class);
            syntaxJsonObject.add("examples", (JsonElement)JSONGenerator.convertToJsonArray(examplesAnnotation.value()));
        } else if (syntaxClass.isAnnotationPresent(Example.Examples.class)) {
            examplesAnnotation = syntaxClass.getAnnotation(Example.Examples.class);
            syntaxJsonObject.add("examples", (JsonElement)JSONGenerator.convertToJsonArray((String[])Arrays.stream(examplesAnnotation.value()).map(Example::value).toArray(String[]::new)));
        } else if (syntaxClass.isAnnotationPresent(Example.class)) {
            @NotNull Example example = syntaxClass.getAnnotation(Example.class);
            syntaxJsonObject.add("examples", (JsonElement)JSONGenerator.convertToJsonArray(example.value()));
        } else {
            syntaxJsonObject.add("examples", null);
        }
        Events events = syntaxClass.getAnnotation(Events.class);
        syntaxJsonObject.add("events", events == null ? null : JSONGenerator.convertToJsonArray(events.value()));
        RequiredPlugins requirements = syntaxClass.getAnnotation(RequiredPlugins.class);
        syntaxJsonObject.add("requirements", requirements == null ? null : JSONGenerator.convertToJsonArray(requirements.value()));
        Keywords keywords = syntaxClass.getAnnotation(Keywords.class);
        syntaxJsonObject.add("keywords", keywords == null ? null : JSONGenerator.convertToJsonArray(keywords.value()));
        return syntaxJsonObject;
    }

    private static JsonObject generateEventElement(SkriptEventInfo<?> info) {
        JsonObject syntaxJsonObject = new JsonObject();
        syntaxJsonObject.addProperty("id", DocumentationIdProvider.getId(info));
        syntaxJsonObject.addProperty("name", info.getName());
        syntaxJsonObject.addProperty("cancellable", Boolean.valueOf(JSONGenerator.isCancellable(info)));
        syntaxJsonObject.add("since", (JsonElement)JSONGenerator.convertToJsonArray(info.getSince()));
        syntaxJsonObject.add("patterns", (JsonElement)JSONGenerator.cleanPatterns(info.getPatterns()));
        syntaxJsonObject.add("description", (JsonElement)JSONGenerator.convertToJsonArray(info.getDescription()));
        syntaxJsonObject.add("requirements", (JsonElement)JSONGenerator.convertToJsonArray(info.getRequiredPlugins()));
        syntaxJsonObject.add("examples", (JsonElement)JSONGenerator.convertToJsonArray(info.getExamples()));
        syntaxJsonObject.add("eventValues", (JsonElement)JSONGenerator.getEventValues(info));
        syntaxJsonObject.add("keywords", (JsonElement)JSONGenerator.convertToJsonArray(info.getKeywords()));
        return syntaxJsonObject;
    }

    private static JsonArray getEventValues(SkriptEventInfo<?> info) {
        HashSet<JsonObject> eventValues = new HashSet<JsonObject>();
        Multimap<Class<? extends Event>, EventValues.EventValueInfo<?, ?>> allEventValues = EventValues.getPerEventEventValues();
        for (Class<? extends Event> supportedEvent : info.events) {
            for (Class event : allEventValues.keySet()) {
                if (!event.isAssignableFrom(supportedEvent)) continue;
                Collection eventValueInfos = allEventValues.get((Object)event);
                for (EventValues.EventValueInfo eventValueInfo : eventValueInfos) {
                    Class valueClass;
                    ClassInfo classInfo;
                    Class<E>[] excludes = eventValueInfo.excludes();
                    if (excludes != null && Set.of(excludes).contains(event) || (classInfo = (valueClass = eventValueInfo.valueClass()).isArray() ? Classes.getExactClassInfo(valueClass.componentType()) : Classes.getExactClassInfo(valueClass)) == null) continue;
                    Object name = classInfo.getName().getSingular();
                    if (valueClass.isArray()) {
                        name = classInfo.getName().getPlural();
                    }
                    if (((String)name).isBlank()) continue;
                    if (eventValueInfo.time() == -1) {
                        name = "past " + (String)name;
                    } else if (eventValueInfo.time() == 1) {
                        name = "future " + (String)name;
                    }
                    JsonObject object = new JsonObject();
                    object.addProperty("id", DocumentationIdProvider.getId(classInfo));
                    object.addProperty("name", ((String)name).toLowerCase(Locale.ENGLISH));
                    eventValues.add(object);
                }
            }
        }
        if (eventValues.isEmpty()) {
            return null;
        }
        JsonArray array = new JsonArray();
        for (JsonObject eventValue : eventValues) {
            array.add((JsonElement)eventValue);
        }
        return array;
    }

    private static boolean isCancellable(SkriptEventInfo<?> info) {
        boolean cancellable = false;
        for (Class<? extends Event> event : info.events) {
            if (!Cancellable.class.isAssignableFrom(event) && !BlockCanBuildEvent.class.isAssignableFrom(event)) continue;
            cancellable = true;
            break;
        }
        return cancellable;
    }

    private static <T extends StructureInfo<? extends Structure>> JsonArray generateStructureElementArray(Iterator<T> infos) {
        JsonArray syntaxArray = new JsonArray();
        infos.forEachRemaining(info -> {
            if (info instanceof SkriptEventInfo) {
                SkriptEventInfo eventInfo = (SkriptEventInfo)info;
                syntaxArray.add((JsonElement)JSONGenerator.generateEventElement(eventInfo));
            } else {
                JsonObject structureElementJsonObject = JSONGenerator.generatedAnnotatedElement(info);
                if (structureElementJsonObject != null) {
                    syntaxArray.add((JsonElement)structureElementJsonObject);
                }
            }
        });
        return syntaxArray;
    }

    private static <T extends SyntaxElementInfo<? extends SyntaxElement>> JsonArray generateSyntaxElementArray(Iterator<T> infos) {
        JsonArray syntaxArray = new JsonArray();
        infos.forEachRemaining(info -> {
            JsonObject syntaxJsonObject = JSONGenerator.generatedAnnotatedElement(info);
            if (syntaxJsonObject != null) {
                syntaxArray.add((JsonElement)syntaxJsonObject);
            }
        });
        return syntaxArray;
    }

    private static JsonObject generateClassInfoElement(ClassInfo<?> classInfo) {
        if (!classInfo.hasDocs()) {
            return null;
        }
        JsonObject syntaxJsonObject = new JsonObject();
        syntaxJsonObject.addProperty("id", DocumentationIdProvider.getId(classInfo));
        syntaxJsonObject.addProperty("name", Objects.requireNonNullElse(classInfo.getDocName(), classInfo.getCodeName()));
        syntaxJsonObject.addProperty("since", classInfo.getSince());
        syntaxJsonObject.add("patterns", (JsonElement)JSONGenerator.cleanPatterns(classInfo.getUsage()));
        syntaxJsonObject.add("description", (JsonElement)JSONGenerator.convertToJsonArray(classInfo.getDescription()));
        syntaxJsonObject.add("requirements", (JsonElement)JSONGenerator.convertToJsonArray(classInfo.getRequiredPlugins()));
        syntaxJsonObject.add("examples", (JsonElement)JSONGenerator.convertToJsonArray(classInfo.getExamples()));
        return syntaxJsonObject;
    }

    private static JsonArray generateClassInfoArray(Iterator<ClassInfo<?>> classInfos) {
        JsonArray syntaxArray = new JsonArray();
        classInfos.forEachRemaining(classInfo -> {
            JsonObject classInfoElement = JSONGenerator.generateClassInfoElement(classInfo);
            if (classInfoElement != null) {
                syntaxArray.add((JsonElement)classInfoElement);
            }
        });
        return syntaxArray;
    }

    private static JsonObject generateFunctionElement(JavaFunction<?> function) {
        JsonObject functionJsonObject = new JsonObject();
        functionJsonObject.addProperty("id", DocumentationIdProvider.getId(function));
        functionJsonObject.addProperty("name", function.getName());
        functionJsonObject.addProperty("since", function.getSince());
        functionJsonObject.add("returnType", (JsonElement)JSONGenerator.getReturnType(function));
        functionJsonObject.add("description", (JsonElement)JSONGenerator.convertToJsonArray(function.getDescription()));
        functionJsonObject.add("examples", (JsonElement)JSONGenerator.convertToJsonArray(function.getExamples()));
        String functionSignature = function.getSignature().toString(false, false);
        functionJsonObject.add("patterns", (JsonElement)JSONGenerator.convertToJsonArray(functionSignature));
        return functionJsonObject;
    }

    private static JsonObject getReturnType(JavaFunction<?> function) {
        JsonObject object = new JsonObject();
        ClassInfo returnType = function.getReturnType();
        if (returnType == null) {
            return null;
        }
        object.addProperty("id", DocumentationIdProvider.getId(returnType));
        object.addProperty("name", Objects.requireNonNullElse(returnType.getDocName(), returnType.getCodeName()));
        return object;
    }

    private static JsonArray generateFunctionArray(Iterator<JavaFunction<?>> functions) {
        JsonArray syntaxArray = new JsonArray();
        functions.forEachRemaining(function -> syntaxArray.add((JsonElement)JSONGenerator.generateFunctionElement(function)));
        return syntaxArray;
    }

    private static JsonArray cleanPatterns(String ... strings) {
        if (strings == null || strings.length == 0 || strings.length == 1 && strings[0].isBlank()) {
            return null;
        }
        for (int i = 0; i < strings.length; ++i) {
            strings[i] = Documentation.cleanPatterns(strings[i], false, false);
        }
        return JSONGenerator.convertToJsonArray(strings);
    }

    private void saveDocs(Path outputPath, JsonObject jsonDocs) {
        try {
            Files.writeString(outputPath, (CharSequence)GSON.toJson((JsonElement)jsonDocs), new OpenOption[0]);
        }
        catch (IOException exception) {
            Skript.exception((Throwable)exception, "An error occurred while trying to generate JSON documentation");
        }
    }

    @Override
    public void generate() {
        JsonObject jsonDocs = new JsonObject();
        jsonDocs.addProperty("skriptVersion", Skript.getVersion().toString());
        jsonDocs.add("version", (JsonElement)JSONGenerator.getVersion());
        jsonDocs.add("conditions", (JsonElement)JSONGenerator.generateSyntaxElementArray(Skript.getConditions().iterator()));
        jsonDocs.add("effects", (JsonElement)JSONGenerator.generateSyntaxElementArray(Skript.getEffects().iterator()));
        jsonDocs.add("expressions", (JsonElement)JSONGenerator.generateSyntaxElementArray(Skript.getExpressions()));
        jsonDocs.add("events", (JsonElement)JSONGenerator.generateStructureElementArray(Skript.getEvents().iterator()));
        jsonDocs.add("classes", (JsonElement)JSONGenerator.generateClassInfoArray(Classes.getClassInfos().iterator()));
        Stream<StructureInfo> structuresExcludingEvents = Skript.getStructures().stream().filter(structureInfo -> !(structureInfo instanceof SkriptEventInfo));
        jsonDocs.add("structures", (JsonElement)JSONGenerator.generateStructureElementArray(structuresExcludingEvents.iterator()));
        jsonDocs.add("sections", (JsonElement)JSONGenerator.generateSyntaxElementArray(Skript.getSections().iterator()));
        jsonDocs.add("functions", (JsonElement)JSONGenerator.generateFunctionArray(Functions.getJavaFunctions().iterator()));
        this.saveDocs(this.outputDir.toPath().resolve("docs.json"), jsonDocs);
    }
}

