/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Force Attack")
@Description(value={"Makes a living entity attack an entity with a melee attack."})
@Examples(value={"spawn a wolf at player's location", "make last spawned wolf attack player"})
@Since(value={"2.5.1"})
@RequiredPlugins(value={"Minecraft 1.15.2+"})
public class EffForceAttack
extends Effect {
    private Expression<LivingEntity> entities;
    private Expression<Entity> target;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.entities = exprs[0];
        this.target = exprs[1];
        return true;
    }

    @Override
    protected void execute(Event e) {
        Entity target = this.target.getSingle(e);
        if (target != null) {
            for (LivingEntity entity : this.entities.getArray(e)) {
                entity.attack(target);
            }
        }
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "make " + this.entities.toString(e, debug) + " attack " + this.target.toString(e, debug);
    }

    static {
        Skript.registerEffect(EffForceAttack.class, "make %livingentities% attack %entity%", "force %livingentities% to attack %entity%");
    }
}

