/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.entity;

import ch.njol.skript.Skript;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.registrations.Classes;
import ch.njol.util.coll.CollectionUtils;
import com.google.common.collect.Iterators;
import java.util.Objects;
import org.bukkit.entity.Pig;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PigData
extends EntityData<Pig> {
    private static final SaddleState[] SADDLE_STATES = SaddleState.values();
    private static final boolean VARIANTS_ENABLED;
    private static final Object[] variants;
    private SaddleState saddled = SaddleState.UNKNOWN;
    @Nullable
    private Object variant = null;

    public PigData() {
    }

    public PigData(SaddleState saddled, @Nullable Object variant) {
        this.saddled = saddled;
        this.variant = variant;
    }

    @Override
    protected boolean init(Literal<?>[] exprs, int matchedPattern, SkriptParser.ParseResult parseResult) {
        this.saddled = SADDLE_STATES[matchedPattern];
        if (VARIANTS_ENABLED) {
            Literal<?> expr = null;
            if (exprs[0] != null) {
                expr = exprs[0];
            } else if (exprs[1] != null) {
                expr = exprs[1];
            }
            if (expr != null) {
                this.variant = expr.getSingle();
            }
        }
        return true;
    }

    @Override
    protected boolean init(@Nullable Class<? extends Pig> entityClass, @Nullable Pig pig) {
        this.saddled = SaddleState.UNKNOWN;
        if (pig != null) {
            SaddleState saddleState = this.saddled = pig.hasSaddle() ? SaddleState.SADDLED : SaddleState.NOT_SADDLED;
            if (VARIANTS_ENABLED) {
                this.variant = pig.getVariant();
            }
        }
        return true;
    }

    @Override
    protected boolean deserialize(String string) {
        return true;
    }

    @Override
    public void set(Pig pig) {
        pig.setSaddle(this.saddled == SaddleState.SADDLED);
        if (VARIANTS_ENABLED) {
            Object finalVariant = this.variant != null ? this.variant : CollectionUtils.getRandom(variants);
            pig.setVariant((Pig.Variant)finalVariant);
        }
    }

    @Override
    protected boolean match(Pig pig) {
        return !(this.saddled != SaddleState.UNKNOWN && (pig.hasSaddle() ? SaddleState.SADDLED : SaddleState.NOT_SADDLED) != this.saddled || this.variant != null && this.variant != pig.getVariant());
    }

    @Override
    public Class<? extends Pig> getType() {
        return Pig.class;
    }

    @Override
    protected boolean equals_i(EntityData<?> obj) {
        if (!(obj instanceof PigData)) {
            return false;
        }
        PigData other = (PigData)obj;
        if (this.saddled != other.saddled) {
            return false;
        }
        return this.variant == other.variant;
    }

    @Override
    protected int hashCode_i() {
        return this.saddled.ordinal() + Objects.hashCode(this.variant);
    }

    @Override
    public boolean isSupertypeOf(EntityData<?> entityData) {
        if (!(entityData instanceof PigData)) {
            return false;
        }
        PigData other = (PigData)entityData;
        if (this.saddled != SaddleState.UNKNOWN && this.saddled != other.saddled) {
            return false;
        }
        return this.variant == null || this.variant == other.variant;
    }

    @Override
    @NotNull
    public EntityData<Pig> getSuperType() {
        return new PigData();
    }

    static {
        EntityData.register(PigData.class, "pig", Pig.class, 1, "unsaddled pig", "pig", "saddled pig");
        if (Skript.classExists("org.bukkit.entity.Pig$Variant")) {
            VARIANTS_ENABLED = true;
            variants = Iterators.toArray(Classes.getExactClassInfo(Pig.Variant.class).getSupplier().get(), Pig.Variant.class);
        } else {
            VARIANTS_ENABLED = false;
            variants = null;
        }
    }

    public static enum SaddleState {
        NOT_SADDLED,
        UNKNOWN,
        SADDLED;

    }

    public static class PigVariantDummy {
    }
}

