/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.entity;

import ch.njol.skript.Skript;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.coll.CollectionUtils;
import java.util.ArrayList;
import java.util.Locale;
import org.bukkit.entity.Salmon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SalmonData
extends EntityData<Salmon> {
    private static final boolean SUPPORT_SALMON_VARIANTS = Skript.classExists("org.bukkit.entity.Salmon$Variant");
    private static Object[] variants;
    @Nullable
    private Object variant;

    @Override
    protected boolean init(Literal<?>[] exprs, int matchedPattern, SkriptParser.ParseResult parseResult) {
        if (matchedPattern > 1) {
            this.variant = variants[matchedPattern - 2];
        }
        return true;
    }

    @Override
    protected boolean init(@Nullable Class<? extends Salmon> c, @Nullable Salmon salmon) {
        if (salmon != null && SUPPORT_SALMON_VARIANTS) {
            this.variant = salmon.getVariant();
        }
        return true;
    }

    @Override
    public void set(Salmon entity) {
        if (SUPPORT_SALMON_VARIANTS) {
            Object variantSet = this.variant != null ? this.variant : CollectionUtils.getRandom(variants);
            entity.setVariant((Salmon.Variant)variantSet);
        }
    }

    @Override
    protected boolean match(Salmon entity) {
        return this.matchedPattern <= 1 || this.variant == entity.getVariant();
    }

    @Override
    public Class<? extends Salmon> getType() {
        return Salmon.class;
    }

    @Override
    @NotNull
    public EntityData getSuperType() {
        return new SalmonData();
    }

    @Override
    protected int hashCode_i() {
        return this.matchedPattern <= 1 ? 0 : this.matchedPattern;
    }

    @Override
    protected boolean equals_i(EntityData<?> obj) {
        if (!(obj instanceof SalmonData)) {
            return false;
        }
        SalmonData salmonData = (SalmonData)obj;
        return this.matchedPattern <= 1 || this.variant == salmonData.variant;
    }

    @Override
    public boolean isSupertypeOf(EntityData<?> entity) {
        if (entity instanceof SalmonData) {
            SalmonData salmonData = (SalmonData)entity;
            return this.matchedPattern <= 1 || this.variant == salmonData.variant;
        }
        return false;
    }

    static {
        ArrayList<Object> patternList = new ArrayList<Object>();
        patternList.add("salmon");
        if (SUPPORT_SALMON_VARIANTS) {
            variants = Salmon.Variant.values();
            patternList.add("any salmon");
            for (Object object : variants) {
                Salmon.Variant variant = (Salmon.Variant)object;
                patternList.add(variant.toString().replace("_", " ").toLowerCase(Locale.ENGLISH) + " salmon");
            }
        }
        EntityData.register(SalmonData.class, "salmon", Salmon.class, 0, (String[])patternList.toArray(String[]::new));
    }
}

