/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.log.BlockingLogHandler;
import ch.njol.util.Kleenean;
import ch.njol.util.StringUtils;
import ch.njol.util.coll.iterator.CheckedIterator;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.util.BoundingBox;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;

@Name(value="Entities")
@Description(value={"All entities in all worlds, in a specific world, in a chunk, in a radius around a certain location or within two locations. e.g. <code>all players</code>, <code>all creepers in the player's world</code>, or <code>players in radius 100 of the player</code>."})
@Examples(value={"kill all creepers in the player's world", "send \"Psst!\" to all players within 100 meters of the player", "give a diamond to all ops", "heal all tamed wolves in radius 2000 around {town center}", "delete all monsters in chunk at player", "size of all players within {_corner::1} and {_corner::2}}"})
@Since(value={"1.2.1, 2.5 (chunks), 2.10 (within)"})
public class ExprEntities
extends SimpleExpression<Entity> {
    Expression<? extends EntityData<?>> types;
    private @UnknownNullability Expression<World> worlds;
    private @UnknownNullability Expression<Chunk> chunks;
    private @UnknownNullability Expression<Number> radius;
    private @UnknownNullability Expression<Location> center;
    private @UnknownNullability Expression<Location> from;
    private @UnknownNullability Expression<Location> to;
    private Class<? extends Entity> returnType = Entity.class;
    private boolean isUsingRadius;
    private boolean isUsingCuboid;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.types = exprs[0];
        if (matchedPattern % 2 == 0) {
            for (EntityData entityType : (EntityData[])((Literal)this.types).getAll()) {
                if (!entityType.isPlural().isFalse() && (!entityType.isPlural().isUnknown() || StringUtils.startsWithIgnoreCase(parseResult.expr, "all"))) continue;
                return false;
            }
        }
        this.isUsingRadius = matchedPattern == 2 || matchedPattern == 3;
        boolean bl = this.isUsingCuboid = matchedPattern >= 4;
        if (this.isUsingRadius) {
            this.radius = exprs[1];
            this.center = exprs[2];
        } else if (this.isUsingCuboid) {
            this.from = exprs[1];
            this.to = exprs[2];
        } else if (parseResult.mark == 1) {
            this.chunks = exprs[2];
        } else {
            this.worlds = exprs[1];
        }
        if (this.types instanceof Literal && ((EntityData[])((Literal)this.types).getAll()).length == 1) {
            this.returnType = ((EntityData)((Literal)this.types).getSingle()).getType();
        }
        return true;
    }

    @Override
    public boolean isLoopOf(String s) {
        if (!(this.types instanceof Literal)) {
            return false;
        }
        try (BlockingLogHandler ignored = new BlockingLogHandler().start();){
            EntityData<?> entityData = EntityData.parseWithoutIndefiniteArticle(s);
            if (entityData != null) {
                for (EntityData entityType : (EntityData[])((Literal)this.types).getAll()) {
                    assert (entityType != null);
                    if (entityData.isSupertypeOf(entityType)) continue;
                    boolean bl = false;
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    protected Entity @Nullable [] get(Event event) {
        if (this.isUsingRadius || this.isUsingCuboid) {
            Iterator<? extends Entity> iter = this.iterator(event);
            if (iter == null || !iter.hasNext()) {
                return null;
            }
            ArrayList<Entity> list = new ArrayList<Entity>();
            while (iter.hasNext()) {
                list.add(iter.next());
            }
            return list.toArray((Entity[])Array.newInstance(this.returnType, list.size()));
        }
        if (this.chunks != null) {
            return EntityData.getAll((EntityData[])this.types.getArray(event), this.returnType, (Chunk[])this.chunks.getArray(event));
        }
        return EntityData.getAll((EntityData[])this.types.getAll(event), this.returnType, this.worlds != null ? this.worlds.getArray(event) : null);
    }

    @Override
    @Nullable
    public Iterator<? extends Entity> iterator(Event event) {
        if (this.isUsingRadius) {
            Location location = this.center.getSingle(event);
            if (location == null) {
                return null;
            }
            Number number = this.radius.getSingle(event);
            if (number == null) {
                return null;
            }
            double rad = number.doubleValue();
            if (location.getWorld() == null) {
                return null;
            }
            Collection nearbyEntities = location.getWorld().getNearbyEntities(location, rad, rad, rad);
            double radiusSquared = rad * rad * 1.00001;
            EntityData[] entityTypes = this.types.getAll(event);
            return new CheckedIterator<Entity>(nearbyEntities.iterator(), entity -> {
                if (entity == null || entity.getLocation().distanceSquared(location) > radiusSquared) {
                    return false;
                }
                for (EntityData entityType : entityTypes) {
                    if (!entityType.isInstance((Entity)entity)) continue;
                    return true;
                }
                return false;
            });
        }
        if (this.isUsingCuboid) {
            Location corner1 = this.from.getSingle(event);
            if (corner1 == null) {
                return null;
            }
            Location corner2 = this.to.getSingle(event);
            if (corner2 == null) {
                return null;
            }
            EntityData[] entityTypes = this.types.getAll(event);
            World world = corner1.getWorld();
            if (world == null) {
                world = corner2.getWorld();
            }
            if (world == null) {
                return null;
            }
            Collection entities = corner1.getWorld().getNearbyEntities(BoundingBox.of((Location)corner1, (Location)corner2));
            return new CheckedIterator<Entity>(entities.iterator(), entity -> {
                if (entity == null) {
                    return false;
                }
                for (EntityData entityType : entityTypes) {
                    if (!entityType.isInstance((Entity)entity)) continue;
                    return true;
                }
                return false;
            });
        }
        if (this.chunks == null || this.returnType == Player.class) {
            return super.iterator(event);
        }
        return Arrays.stream(EntityData.getAll((EntityData[])this.types.getArray(event), this.returnType, (Chunk[])this.chunks.getArray(event))).iterator();
    }

    @Override
    public boolean isSingle() {
        return false;
    }

    @Override
    public Class<? extends Entity> getReturnType() {
        return this.returnType;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        String message = "all entities of type " + this.types.toString(e, debug);
        if (this.worlds != null) {
            message = message + " in " + this.worlds.toString(e, debug);
        } else if (this.radius != null && this.center != null) {
            message = message + " in radius " + this.radius.toString(e, debug) + " around " + this.center.toString(e, debug);
        } else if (this.from != null && this.to != null) {
            message = message + " within " + this.from.toString(e, debug) + " and " + this.to.toString(e, debug);
        }
        return message;
    }

    static {
        Skript.registerExpression(ExprEntities.class, Entity.class, ExpressionType.PATTERN_MATCHES_EVERYTHING, "[(all [[of] the]|the)] %*entitydatas% [(in|of) ([world[s]] %-worlds%|1\u00a6%-chunks%)]", "[(all [[of] the]|the)] entities of type[s] %entitydatas% [(in|of) ([world[s]] %-worlds%|1\u00a6%-chunks%)]", "[(all [[of] the]|the)] %*entitydatas% (within|[with]in radius) %number% [(block[s]|met(er|re)[s])] (of|around) %location%", "[(all [[of] the]|the)] entities of type[s] %entitydatas% in radius %number% (of|around) %location%", "[(all [[of] the]|the)] %*entitydatas% within %location% and %location%", "[(all [[of] the]|the)] entities of type[s] %entitydatas% within %location% and %location%");
    }
}

