/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.KeyProviderExpression;
import ch.njol.skript.lang.KeyedValue;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.SyntaxStringBuilder;
import ch.njol.skript.lang.simplification.SimplifiedLiteral;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.util.LiteralUtils;
import ch.njol.util.Kleenean;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Indices Of")
@Description(value={"Get the first, last or all positions of a character (or text) in another text using 'positions of %text% in %text%'. Nothing is returned when the value does not occur in the text. Positions range from 1 to the <a href='#ExprIndicesOf'>length</a> of the text (inclusive).", "", "Using 'indices/positions of %objects% in %objects%', you can get the indices or positions of a list where the value at that index is the provided value. Indices are only supported for keyed expressions (e.g. variable lists) and will return the string indices of the given value. Positions can be used with any list and will return the numerical position of the value in the list, counting up from 1. As well, nothing is returned if the value is not found in the list."})
@Examples(value={"set {_first} to the first position of \"@\" in the text argument", "if {_s} contains \"abc\":", "\tset {_s} to the first (position of \"abc\" in {_s} + 3) characters of {_s}", "\t# removes everything after the first \"abc\" from {_s}", "", "set {_list::*} to 1, 2, 3, 1, 2, 3", "set {_indices::*} to indices of the value 1 in {_list::*}", "# {_indices::*} is now \"1\" and \"4\"", "", "set {_indices::*} to all indices of the value 2 in {_list::*}", "# {_indices::*} is now \"2\" and \"5\"", "", "set {_positions::*} to all positions of the value 3 in {_list::*}", "# {_positions::*} is now 3 and 6", "", "set {_otherlist::bar} to 100", "set {_otherlist::hello} to \"hi\"", "set {_otherlist::burb} to 100", "set {_otherlist::tud} to \"hi\"", "set {_otherlist::foo} to 100", "", "set {_indices::*} to the first index of the value 100 in {_otherlist::*}", "# {_indices::*} is now \"bar\"", "set {_indices::*} to the last index of the value 100 in {_otherlist::*}", "# {_indices::*} is now \"foo\"", "", "set {_positions::*} to all positions of the value 100 in {_otherlist::*}", "# {_positions::*} is now 1, 3 and 5", "set {_positions::*} to all positions of the value \"hi\" in {_otherlist::*}", "# {_positions::*} is now 2 and 4"})
@Since(value={"2.1, 2.12 (indices, positions of list)"})
public class ExprIndicesOf
extends SimpleExpression<Object> {
    private IndexType indexType;
    private boolean position;
    private boolean string;
    private Expression<?> value;
    private Expression<?> objects;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (exprs[1].isSingle() && matchedPattern > 0) {
            Skript.error("'" + String.valueOf(exprs[1]) + "' can only ever have one value at most, thus the 'indices of x in list' expression has no effect.");
            return false;
        }
        if (!KeyProviderExpression.canReturnKeys(exprs[1]) && matchedPattern == 2) {
            Skript.error("'" + String.valueOf(exprs[1]) + "' is not a keyed expression. You can only get the indices of a keyed expression.");
            return false;
        }
        this.indexType = IndexType.values()[parseResult.mark == 0 ? 0 : parseResult.mark - 1];
        if (parseResult.mark == 0 && parseResult.hasTag("mult")) {
            this.indexType = IndexType.ALL;
        }
        this.position = matchedPattern <= 1;
        this.string = matchedPattern == 0;
        this.value = LiteralUtils.defendExpression(exprs[0]);
        this.objects = exprs[1];
        return LiteralUtils.canInitSafely(this.value);
    }

    @Override
    protected Object @Nullable [] get(Event event) {
        Object value = this.value.getSingle(event);
        if (value == null) {
            return (Object[])Array.newInstance(this.getReturnType(), 0);
        }
        if (this.position) {
            if (this.string) {
                String haystack = (String)this.objects.getSingle(event);
                if (haystack == null) {
                    return new Long[0];
                }
                return this.getStringPositions(haystack, (String)value);
            }
            return this.getListPositions(this.objects, value, event);
        }
        assert (this.objects instanceof KeyProviderExpression);
        return this.getIndices((KeyProviderExpression)this.objects, value, event);
    }

    private Long[] getStringPositions(String haystack, String needle) {
        ArrayList<Long> positions = new ArrayList<Long>();
        long position = haystack.indexOf(needle);
        if (position == -1L) {
            return new Long[0];
        }
        if (this.indexType == IndexType.ALL) {
            while (position != -1L) {
                positions.add(position + 1L);
                position = haystack.indexOf(needle, (int)position + 1);
            }
            return positions.toArray(new Long[0]);
        }
        if (this.indexType == IndexType.LAST) {
            position = haystack.lastIndexOf(needle);
        }
        return new Long[]{position + 1L};
    }

    private Long[] getListPositions(Expression<?> list, Object value, Event event) {
        Iterator iterator = list.iterator(event);
        if (iterator == null) {
            return new Long[0];
        }
        ArrayList<Long> positions = new ArrayList<Long>();
        long position = 0L;
        while (iterator.hasNext()) {
            ++position;
            if (!iterator.next().equals(value)) continue;
            if (this.indexType == IndexType.FIRST) {
                return new Long[]{position};
            }
            positions.add(position);
        }
        if (this.indexType == IndexType.LAST) {
            return new Long[]{(Long)positions.get(positions.size() - 1)};
        }
        return (Long[])positions.toArray(Long[]::new);
    }

    private String[] getIndices(KeyProviderExpression<?> expression, Object value, Event event) {
        Iterator<KeyedValue<?>> iterator = expression.keyedIterator(event);
        if (iterator == null) {
            return new String[0];
        }
        ArrayList<String> indices = new ArrayList<String>();
        while (iterator.hasNext()) {
            KeyedValue<?> keyedValue = iterator.next();
            if (!keyedValue.value().equals(value)) continue;
            if (this.indexType == IndexType.FIRST) {
                return new String[]{keyedValue.key()};
            }
            indices.add(keyedValue.key());
        }
        if (indices.isEmpty()) {
            return new String[0];
        }
        if (this.indexType == IndexType.LAST) {
            return new String[]{(String)indices.get(indices.size() - 1)};
        }
        return (String[])indices.toArray(String[]::new);
    }

    @Override
    public boolean isSingle() {
        return this.indexType == IndexType.FIRST || this.indexType == IndexType.LAST;
    }

    @Override
    public Class<?> getReturnType() {
        if (this.position) {
            return Long.class;
        }
        return String.class;
    }

    @Override
    public Expression<?> simplify() {
        if (this.position && this.string && this.value instanceof Literal && this.objects instanceof Literal) {
            return SimplifiedLiteral.fromExpression(this);
        }
        return this;
    }

    @Override
    public String toString(@Nullable Event event, boolean debug) {
        SyntaxStringBuilder builder = new SyntaxStringBuilder(event, debug);
        builder.append((Object)this.indexType.name().toLowerCase(Locale.ENGLISH));
        if (this.position) {
            builder.append((Object)"positions");
        } else {
            builder.append((Object)"indices");
        }
        builder.append("of value", this.value, "in", this.objects);
        return builder.toString();
    }

    static {
        Skript.registerExpression(ExprIndicesOf.class, Object.class, ExpressionType.COMBINED, "[the] [1:first|2:last|3:all] (position[mult:s]|mult:indices|index[mult:es]) of [[the] value] %string% in %string%", "[the] [1:first|2:last|3:all] position[mult:s] of [[the] value] %object% in %~objects%", "[the] [1:first|2:last|3:all] (mult:indices|index[mult:es]) of [[the] value] %object% in %~objects%");
    }

    private static enum IndexType {
        FIRST,
        LAST,
        ALL;

    }
}

