/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.patterns;

import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.log.ParseLogHandler;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.skript.patterns.MatchResult;
import ch.njol.skript.patterns.PatternElement;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;

public class RegexPatternElement
extends PatternElement {
    private final Pattern pattern;

    public RegexPatternElement(Pattern pattern) {
        this.pattern = pattern;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public MatchResult match(String expr, MatchResult matchResult) {
        int exprIndex = matchResult.exprOffset;
        ParseLogHandler log = SkriptLogger.startParseLogHandler();
        try {
            Matcher matcher = this.pattern.matcher(expr);
            int nextExprOffset = SkriptParser.next(expr, exprIndex, matchResult.parseContext);
            while (nextExprOffset != -1) {
                log.clear();
                matcher.region(exprIndex, nextExprOffset);
                if (matcher.matches()) {
                    MatchResult matchResultCopy = matchResult.copy();
                    matchResultCopy.exprOffset = nextExprOffset;
                    MatchResult newMatchResult = this.matchNext(expr, matchResultCopy);
                    if (newMatchResult != null) {
                        newMatchResult.regexResults.add(0, matcher.toMatchResult());
                        log.printLog();
                        MatchResult matchResult2 = newMatchResult;
                        return matchResult2;
                    }
                }
                nextExprOffset = SkriptParser.next(expr, nextExprOffset, matchResult.parseContext);
            }
            log.printError(null);
            MatchResult matchResult3 = null;
            return matchResult3;
        }
        finally {
            log.stop();
        }
    }

    @Override
    public String toString() {
        return "<" + String.valueOf(this.pattern) + ">";
    }
}

