/*
 * Decompiled with CFR 0.152.
 */
package org.skriptlang.skript.bukkit.fishing.elements;

import ch.njol.skript.conditions.base.PropertyCondition;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Events;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FishHook;

@Name(value="Is Fish Hook in Open Water")
@Description(value={"Checks whether the fish hook is in open water.", "Open water is defined by a 5x4x5 area of water, air and lily pads. If in open water, treasure items may be caught."})
@Examples(value={"on fish catch:", "\tif fish hook is in open water:", "\t\tsend \"You will catch a shark soon!\""})
@Events(value={"Fishing"})
@Since(value={"2.10"})
public class CondIsInOpenWater
extends PropertyCondition<Entity> {
    @Override
    public boolean check(Entity entity) {
        if (!(entity instanceof FishHook)) {
            return false;
        }
        FishHook hook = (FishHook)entity;
        return hook.isInOpenWater();
    }

    @Override
    protected String getPropertyName() {
        return "in open water";
    }

    static {
        CondIsInOpenWater.register(CondIsInOpenWater.class, "in open water[s]", "entities");
    }
}

