/*
 * Decompiled with CFR 0.152.
 */
package org.skriptlang.skript.registration;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import org.jetbrains.annotations.Nullable;
import org.skriptlang.skript.registration.SyntaxInfo;

final class SyntaxRegister<I extends SyntaxInfo<?>> {
    private static final Comparator<SyntaxInfo<?>> SET_COMPARATOR = (a, b) -> {
        if (a == b) {
            return 0;
        }
        int result = a.priority().compareTo(b.priority());
        return result != 0 ? result : Integer.compare(a.hashCode(), b.hashCode());
    };
    final Set<I> syntaxes = new ConcurrentSkipListSet(SET_COMPARATOR);
    @Nullable
    private volatile Set<I> cache = null;

    SyntaxRegister() {
    }

    public Collection<I> syntaxes() {
        if (this.cache == null) {
            this.cache = ImmutableSet.copyOf(this.syntaxes);
        }
        return this.cache;
    }

    public void add(I info) {
        this.syntaxes.add(info);
        this.cache = null;
    }

    public void remove(I info) {
        this.syntaxes.remove(info);
        this.cache = null;
    }
}

