/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.destroystokyo.paper.event.player.PlayerElytraBoostEvent;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Will Consume Boosting Firework")
@Description(value={"Checks to see if the firework used in an 'elytra boost' event will be consumed."})
@Examples(value={"on elytra boost:", "\tif the used firework will be consumed:", "\t\tprevent the used firework from being consume"})
@RequiredPlugins(value={"Paper"})
@Since(value={"2.10"})
public class CondElytraBoostConsume
extends Condition {
    private boolean checkConsume;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (!this.getParser().isCurrentEvent((Class<? extends Event>)PlayerElytraBoostEvent.class)) {
            Skript.error("This condition can only be used in an 'elytra boost' event.");
            return false;
        }
        this.checkConsume = matchedPattern == 0;
        return true;
    }

    @Override
    public boolean check(Event event) {
        if (!(event instanceof PlayerElytraBoostEvent)) {
            return false;
        }
        PlayerElytraBoostEvent boostEvent = (PlayerElytraBoostEvent)event;
        return boostEvent.shouldConsume() == this.checkConsume;
    }

    @Override
    public String toString(@Nullable Event event, boolean debug) {
        return "the boosting firework will " + (this.checkConsume ? "" : "not") + " be consumed";
    }

    static {
        if (Skript.classExists("com.destroystokyo.paper.event.player.PlayerElytraBoostEvent")) {
            Skript.registerCondition(CondElytraBoostConsume.class, "[the] (boosting|used) firework will be consumed", "[the] (boosting|used) firework (will not|won't) be consumed");
        }
    }
}

