/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.conditions.base.PropertyCondition;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.Nullable;

@Name(value="Has Potion")
@Description(value={"Checks whether the given living entities have specific potion effects."})
@Examples(value={"if player has potion speed:", "\tsend \"You are sonic!\"", "", "if all players have potion effects speed and haste:", "\tbroadcast \"You are ready to MINE!\""})
@Since(value={"2.6.1"})
public class CondHasPotion
extends Condition {
    private Expression<LivingEntity> livingEntities;
    private Expression<PotionEffectType> potionEffects;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.livingEntities = exprs[0];
        this.potionEffects = exprs[1];
        this.setNegated(matchedPattern == 1);
        return true;
    }

    @Override
    public boolean check(Event e) {
        return this.livingEntities.check(e, livingEntity -> this.potionEffects.check(e, arg_0 -> ((LivingEntity)livingEntity).hasPotionEffect(arg_0)), this.isNegated());
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return PropertyCondition.toString(this, PropertyCondition.PropertyType.HAVE, e, debug, this.livingEntities, "potion " + this.potionEffects.toString(e, debug));
    }

    static {
        Skript.registerCondition(CondHasPotion.class, "%livingentities% (has|have) potion[s] [effect[s]] %potioneffecttypes%", "%livingentities% (doesn't|does not|do not|don't) have potion[s] [effect[s]] %potioneffecttypes%");
    }
}

