/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.entity;

import ch.njol.skript.Skript;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.Patterns;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import com.google.common.collect.Iterators;
import java.util.Objects;
import org.bukkit.entity.Pig;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PigData
extends EntityData<Pig> {
    private static final boolean VARIANTS_ENABLED;
    private static final Object[] VARIANTS;
    private static final Patterns<Kleenean> PATTERNS;
    private Kleenean saddled = Kleenean.UNKNOWN;
    @Nullable
    private Object variant = null;

    public PigData() {
    }

    public PigData(@Nullable Kleenean saddled, @Nullable Object variant) {
        this.saddled = saddled != null ? saddled : Kleenean.UNKNOWN;
        this.variant = variant;
    }

    @Override
    protected boolean init(Literal<?>[] exprs, int matchedPattern, SkriptParser.ParseResult parseResult) {
        this.saddled = PATTERNS.getInfo(matchedPattern);
        if (VARIANTS_ENABLED) {
            Literal<?> expr = null;
            if (exprs[0] != null) {
                expr = exprs[0];
            } else if (exprs.length >= 2 && exprs[1] != null) {
                expr = exprs[1];
            }
            if (expr != null) {
                this.variant = expr.getSingle();
            }
        }
        return true;
    }

    @Override
    protected boolean init(@Nullable Class<? extends Pig> entityClass, @Nullable Pig pig) {
        this.saddled = Kleenean.UNKNOWN;
        if (pig != null) {
            this.saddled = Kleenean.get(pig.hasSaddle());
            if (VARIANTS_ENABLED) {
                this.variant = pig.getVariant();
            }
        }
        return true;
    }

    @Override
    public void set(Pig pig) {
        pig.setSaddle(this.saddled.isTrue());
        if (VARIANTS_ENABLED) {
            Object finalVariant = this.variant != null ? this.variant : CollectionUtils.getRandom(VARIANTS);
            pig.setVariant((Pig.Variant)finalVariant);
        }
    }

    @Override
    protected boolean match(Pig pig) {
        if (!this.saddled.isUnknown() && this.saddled != Kleenean.get(pig.hasSaddle())) {
            return false;
        }
        return this.variant == null || this.variant == pig.getVariant();
    }

    @Override
    public Class<? extends Pig> getType() {
        return Pig.class;
    }

    @Override
    protected boolean equals_i(EntityData<?> obj) {
        if (!(obj instanceof PigData)) {
            return false;
        }
        PigData other = (PigData)obj;
        if (this.saddled != other.saddled) {
            return false;
        }
        return this.variant == other.variant;
    }

    @Override
    protected int hashCode_i() {
        return this.saddled.ordinal() + Objects.hashCode(this.variant);
    }

    @Override
    public boolean isSupertypeOf(EntityData<?> entityData) {
        if (!(entityData instanceof PigData)) {
            return false;
        }
        PigData other = (PigData)entityData;
        if (!this.saddled.isUnknown() && this.saddled != other.saddled) {
            return false;
        }
        return this.variant == null || this.variant == other.variant;
    }

    @Override
    @NotNull
    public EntityData<Pig> getSuperType() {
        return new PigData();
    }

    static {
        PATTERNS = new Patterns(new Object[][]{{"pig", Kleenean.UNKNOWN}, {"saddled pig", Kleenean.TRUE}, {"unsaddled pig", Kleenean.FALSE}});
        EntityData.register(PigData.class, "pig", Pig.class, 0, PATTERNS.getPatterns());
        if (Skript.classExists("org.bukkit.entity.Pig$Variant")) {
            VARIANTS_ENABLED = true;
            VARIANTS = Iterators.toArray(Classes.getExactClassInfo(Pig.Variant.class).getSupplier().get(), Pig.Variant.class);
        } else {
            VARIANTS_ENABLED = false;
            VARIANTS = null;
        }
    }

    public static class PigVariantDummy {
    }
}

