/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.KeyProviderExpression;
import ch.njol.skript.lang.KeyedValue;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.ConvertedExpression;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.sections.SecLoop;
import ch.njol.skript.util.Utils;
import ch.njol.util.Kleenean;
import java.lang.reflect.Array;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;
import org.skriptlang.skript.lang.converter.ConverterInfo;
import org.skriptlang.skript.lang.converter.Converters;

@Name(value="Loop value")
@Description(value={"Returns the previous, current, or next looped value."})
@Examples(value={"# Countdown", "loop 10 times:", "\tmessage \"%11 - loop-number%\"", "\twait a second", "", "# Generate a 10x10 floor made of randomly colored wool below the player", "loop blocks from the block below the player to the block 10 east of the block below the player:", "\tloop blocks from the loop-block to the block 10 north of the loop-block:", "\t\tset loop-block-2 to any wool", "", "loop {top-balances::*}:", "\tloop-iteration <= 10", "\tsend \"#%loop-iteration% %loop-index% has $%loop-value%\"", "", "loop shuffled (integers between 0 and 8):", "\tif all:", "\t\tprevious loop-value = 1", "\t\tloop-value = 4", "\t\tnext loop-value = 8", "\tthen:", "\t\t kill all players"})
@Since(value={"1.0, 2.8.0 (loop-counter), 2.10 (previous, next)"})
public class ExprLoopValue
extends SimpleExpression<Object> {
    private static final LoopState[] loopStates = LoopState.values();
    private String name;
    private SecLoop loop;
    boolean isKeyedLoop = false;
    boolean isIndex = false;
    private LoopState selectedState;
    private static final Pattern LOOP_PATTERN;

    @Override
    public boolean init(Expression<?>[] vars, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        this.selectedState = loopStates[matchedPattern];
        this.name = parser.expr;
        String s = parser.regexes.get(0).group();
        int i = -1;
        Matcher m = LOOP_PATTERN.matcher(s);
        if (m.matches()) {
            s = m.group(1);
            i = Utils.parseInt(m.group(2));
        }
        if ("counter".equalsIgnoreCase(s) || "iteration".equalsIgnoreCase(s)) {
            return false;
        }
        Class<?> c = Classes.getClassFromUserInput(s);
        int j = 1;
        SecLoop loop = null;
        for (SecLoop l : this.getParser().getCurrentSections(SecLoop.class)) {
            if ((c == null || !l.getLoopedExpression().canReturn(c)) && !"value".equalsIgnoreCase(s) && !l.getLoopedExpression().isLoopOf(s)) continue;
            if (j < i) {
                ++j;
                continue;
            }
            if (loop != null) {
                Skript.error("There are multiple loops that match loop-" + s + ". Use loop-" + s + "-1/2/3/etc. to specify which loop's value you want.");
                return false;
            }
            loop = l;
            if (j != i) continue;
            break;
        }
        if (loop == null) {
            Skript.error("There's no loop that matches 'loop-" + s + "'");
            return false;
        }
        if (this.selectedState == LoopState.NEXT && !loop.supportsPeeking()) {
            Skript.error("The expression '" + loop.getExpression().toString() + "' does not allow the usage of 'next loop-" + s + "'.");
            return false;
        }
        if (loop.isKeyedLoop()) {
            this.isKeyedLoop = true;
            if (((KeyProviderExpression)loop.getLoopedExpression()).isIndexLoop(s)) {
                this.isIndex = true;
            }
        }
        this.loop = loop;
        return true;
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    @Override
    @Nullable
    protected <R> ConvertedExpression<Object, ? extends R> getConvertedExpr(Class<R> ... to) {
        if (this.isKeyedLoop && !this.isIndex) {
            Class<?> superType = Utils.getSuperType(to);
            return new ConvertedExpression<Object, Object>(this, superType, new ConverterInfo<Object, Object>(Object.class, superType, o -> Converters.convert(o, to), 0));
        }
        return super.getConvertedExpr(to);
    }

    @Override
    public Class<?> getReturnType() {
        if (this.isIndex) {
            return String.class;
        }
        return this.loop.getLoopedExpression().getReturnType();
    }

    @Override
    public Class<?>[] possibleReturnTypes() {
        if (this.isIndex) {
            return new Class[]{String.class};
        }
        return this.loop.getLoopedExpression().possibleReturnTypes();
    }

    @Override
    public boolean canReturn(Class<?> returnType) {
        if (this.isIndex) {
            return super.canReturn(returnType);
        }
        return this.loop.getLoopedExpression().canReturn(returnType);
    }

    @Override
    protected Object @Nullable [] get(Event event) {
        if (this.isKeyedLoop) {
            KeyedValue value = (KeyedValue)(switch (this.selectedState.ordinal()) {
                default -> throw new IncompatibleClassChangeError();
                case 0 -> this.loop.getCurrent(event);
                case 1 -> this.loop.getNext(event);
                case 2 -> this.loop.getPrevious(event);
            });
            if (value == null) {
                return null;
            }
            if (this.isIndex) {
                return new String[]{value.key()};
            }
            Object[] one = (Object[])Array.newInstance(this.getReturnType(), 1);
            one[0] = value.value();
            return one;
        }
        Object[] one = (Object[])Array.newInstance(this.getReturnType(), 1);
        one[0] = switch (this.selectedState.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> this.loop.getCurrent(event);
            case 1 -> this.loop.getNext(event);
            case 2 -> this.loop.getPrevious(event);
        };
        return one;
    }

    @Override
    public String toString(@Nullable Event event, boolean debug) {
        if (event == null) {
            return this.name;
        }
        if (this.isKeyedLoop) {
            KeyedValue value = (KeyedValue)(switch (this.selectedState.ordinal()) {
                default -> throw new IncompatibleClassChangeError();
                case 0 -> this.loop.getCurrent(event);
                case 1 -> this.loop.getNext(event);
                case 2 -> this.loop.getPrevious(event);
            });
            if (value == null) {
                return Classes.getDebugMessage(null);
            }
            return this.isIndex ? "\"" + value.key() + "\"" : Classes.getDebugMessage(value.value());
        }
        return Classes.getDebugMessage(switch (this.selectedState.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> this.loop.getCurrent(event);
            case 1 -> this.loop.getNext(event);
            case 2 -> this.loop.getPrevious(event);
        });
    }

    static {
        String[] patterns = new String[loopStates.length];
        for (LoopState state : loopStates) {
            patterns[state.ordinal()] = "[the] " + state.pattern + " loop-<.+>";
        }
        Skript.registerExpression(ExprLoopValue.class, Object.class, ExpressionType.SIMPLE, patterns);
        LOOP_PATTERN = Pattern.compile("^(.+)-(\\d+)$");
    }

    static enum LoopState {
        CURRENT("[current]"),
        NEXT("next"),
        PREVIOUS("previous");

        private final String pattern;

        private LoopState(String pattern) {
            this.pattern = pattern;
        }
    }
}

