/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.lang;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptAPIException;
import ch.njol.skript.SkriptConfig;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.classes.Parser;
import ch.njol.skript.command.Argument;
import ch.njol.skript.command.Commands;
import ch.njol.skript.command.ScriptCommand;
import ch.njol.skript.command.ScriptCommandEvent;
import ch.njol.skript.lang.DefaultExpression;
import ch.njol.skript.lang.EventRestrictedSyntax;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionList;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.LiteralList;
import ch.njol.skript.lang.LiteralString;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.lang.SkriptEventInfo;
import ch.njol.skript.lang.SyntaxElement;
import ch.njol.skript.lang.UnparsedLiteral;
import ch.njol.skript.lang.Variable;
import ch.njol.skript.lang.VariableString;
import ch.njol.skript.lang.function.ExprFunctionCall;
import ch.njol.skript.lang.function.FunctionReference;
import ch.njol.skript.lang.parser.DefaultValueData;
import ch.njol.skript.lang.parser.ParseStackOverflowException;
import ch.njol.skript.lang.parser.ParserInstance;
import ch.njol.skript.lang.parser.ParsingStack;
import ch.njol.skript.lang.simplification.Simplifiable;
import ch.njol.skript.lang.util.SimpleLiteral;
import ch.njol.skript.localization.Language;
import ch.njol.skript.localization.Message;
import ch.njol.skript.localization.Noun;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.skript.log.LogEntry;
import ch.njol.skript.log.ParseLogHandler;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.skript.patterns.MalformedPatternException;
import ch.njol.skript.patterns.MatchResult;
import ch.njol.skript.patterns.PatternCompiler;
import ch.njol.skript.patterns.SkriptPattern;
import ch.njol.skript.patterns.TypePatternElement;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.Utils;
import ch.njol.util.Kleenean;
import ch.njol.util.NonNullPair;
import ch.njol.util.StringUtils;
import ch.njol.util.coll.CollectionUtils;
import ch.njol.util.coll.iterator.CheckedIterator;
import com.google.common.primitives.Booleans;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Stream;
import org.bukkit.event.Event;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.skriptlang.skript.lang.converter.Converters;
import org.skriptlang.skript.lang.experiment.ExperimentSet;
import org.skriptlang.skript.lang.experiment.ExperimentalSyntax;
import org.skriptlang.skript.lang.script.Script;
import org.skriptlang.skript.lang.script.ScriptWarning;
import org.skriptlang.skript.registration.DefaultSyntaxInfos;
import org.skriptlang.skript.registration.SyntaxInfo;
import org.skriptlang.skript.registration.SyntaxRegistry;

public class SkriptParser {
    private final String expr;
    public static final int PARSE_EXPRESSIONS = 1;
    public static final int PARSE_LITERALS = 2;
    public static final int ALL_FLAGS = 3;
    private final int flags;
    public final boolean doSimplification = SkriptConfig.simplifySyntaxesOnParse.value();
    public final ParseContext context;
    public static final String WILDCARD = "[^\"]*?(?:\"[^\"]*?\"[^\"]*?)*?";
    private static final Pattern VARIABLE_PATTERN = Pattern.compile("((the )?var(iable)? )?\\{.+\\}", 2);
    private static final Pattern LITERAL_SPECIFICATION_PATTERN = Pattern.compile("(?<literal>[^(]+) \\((?<classinfo>[^)]+)\\)");
    public static final Pattern LIST_SPLIT_PATTERN = Pattern.compile("\\s*,?\\s+(and|n?or)\\s+|\\s*,\\s*", 2);
    public static final Pattern OR_PATTERN = Pattern.compile("\\sor\\s", 2);
    private static final String MULTIPLE_AND_OR = "List has multiple 'and' or 'or', will default to 'and'. Use brackets if you want to define multiple lists.";
    private static final String MISSING_AND_OR = "List is missing 'and' or 'or', defaulting to 'and'";
    private boolean suppressMissingAndOrWarnings = SkriptConfig.disableMissingAndOrWarnings.value();
    private static final Pattern FUNCTION_CALL_PATTERN = Pattern.compile("([\\p{IsAlphabetic}_][\\p{IsAlphabetic}\\p{IsDigit}_]*)\\((.*)\\)");
    private static final Map<String, SkriptPattern> patterns = new ConcurrentHashMap<String, SkriptPattern>();
    private static final Message M_QUOTES_ERROR = new Message("skript.quotes error");
    private static final Message M_BRACKETS_ERROR = new Message("skript.brackets error");
    @Deprecated(since="2.7.0", forRemoval=true)
    public static final Pattern listSplitPattern;
    @Deprecated(since="2.8.0", forRemoval=true)
    public static final String wildcard = "[^\"]*?(?:\"[^\"]*?\"[^\"]*?)*?";

    public SkriptParser(String expr) {
        this(expr, 3);
    }

    public SkriptParser(String expr, int flags) {
        this(expr, flags, ParseContext.DEFAULT);
    }

    public SkriptParser(String expr, int flags, ParseContext context) {
        assert (expr != null);
        assert ((flags & 3) != 0);
        this.expr = expr.trim();
        this.flags = flags;
        this.context = context;
    }

    public SkriptParser(SkriptParser other, String expr) {
        this(expr, other.flags, other.context);
    }

    @Nullable
    public static <T> Literal<? extends T> parseLiteral(String expr, Class<T> expectedClass, ParseContext context) {
        if (((String)(expr = ((String)expr).trim())).isEmpty()) {
            return null;
        }
        return new UnparsedLiteral((String)expr).getConvertedExpression(context, expectedClass);
    }

    @Nullable
    public static <T extends SyntaxElement> T parse(String expr, Iterator<? extends SyntaxInfo<T>> source, @Nullable String defaultError) {
        if (((String)(expr = ((String)expr).trim())).isEmpty()) {
            Skript.error(defaultError);
            return null;
        }
        try (ParseLogHandler log = SkriptLogger.startParseLogHandler();){
            T element = new SkriptParser((String)expr).parse(source);
            if (element != null) {
                log.printLog();
                T t = element;
                return t;
            }
            log.printError(defaultError);
            T t = null;
            return t;
        }
    }

    @Nullable
    public static <T extends SyntaxElement> T parseStatic(String expr, Iterator<? extends SyntaxInfo<? extends T>> source, @Nullable String defaultError) {
        return SkriptParser.parseStatic(expr, source, ParseContext.DEFAULT, defaultError);
    }

    @Nullable
    public static <T extends SyntaxElement> T parseStatic(String expr, Iterator<? extends SyntaxInfo<? extends T>> source, ParseContext parseContext, @Nullable String defaultError) {
        if ((expr = expr.trim()).isEmpty()) {
            Skript.error(defaultError);
            return null;
        }
        try (ParseLogHandler log = SkriptLogger.startParseLogHandler();){
            T element = new SkriptParser(expr, 2, parseContext).parse(source);
            if (element != null) {
                log.printLog();
                T t = element;
                return t;
            }
            log.printError(defaultError);
            T t = null;
            return t;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private <T extends SyntaxElement> T parse(Iterator<? extends SyntaxInfo<? extends T>> source) {
        block26: {
            parsingStack = SkriptParser.getParser().getParsingStack();
            log = SkriptLogger.startParseLogHandler();
            while (true) {
                if (!source.hasNext()) {
                    log.printError();
                    var4_4 = null;
                    return var4_4;
                }
                break block26;
                break;
            }
            finally {
                if (log != null) {
                    log.close();
                }
            }
        }
        info = source.next();
        matchedPattern = -1;
        var6_8 = info.patterns().iterator();
        while (true) {
            if (!var6_8.hasNext()) ** continue;
            pattern = var6_8.next();
            ++matchedPattern;
            log.clear();
            try {
                parsingStack.push(new ParsingStack.Element(info, matchedPattern));
                parseResult = this.parse_i(pattern);
            }
            catch (MalformedPatternException e) {
                message = "pattern compiling exception, element class: " + info.type().getName();
                try {
                    providingPlugin = JavaPlugin.getProvidingPlugin(info.type());
                    message = message + " (provided by " + providingPlugin.getName() + ")";
                    throw new RuntimeException(message, e);
                }
                catch (IllegalArgumentException | IllegalStateException providingPlugin) {
                    // empty catch block
                }
                throw new RuntimeException(message, e);
            }
            catch (StackOverflowError e) {
                throw new ParseStackOverflowException(e, new ParsingStack(parsingStack));
            }
            finally {
                stackElement = parsingStack.pop();
                if (!SkriptParser.$assertionsDisabled) {
                    if (stackElement.syntaxElementInfo() != info) throw new AssertionError();
                    if (stackElement.patternIndex() != matchedPattern) {
                        throw new AssertionError();
                    }
                }
            }
            if (parseResult == null) ** continue;
            if (!SkriptParser.$assertionsDisabled && parseResult.source == null) {
                throw new AssertionError();
            }
            types = null;
            for (i = 0; i < parseResult.exprs.length; ++i) {
                if (parseResult.exprs[i] != null) continue;
                if (types == null) {
                    types = parseResult.source.getElements(TypePatternElement.class);
                }
                exprInfo = ((TypePatternElement)types.get(i)).getExprInfo();
                if (exprInfo.isOptional) continue;
                expr = SkriptParser.getDefaultExpression(exprInfo, pattern);
                if (!expr.init()) ** continue;
                parseResult.exprs[i] = expr;
            }
            element = info.instance();
            if (SkriptParser.checkRestrictedEvents(element, parseResult) && SkriptParser.checkExperimentalSyntax(element) && (success = element.preInit() != false && element.init(parseResult.exprs, matchedPattern, SkriptParser.getParser().getHasDelayBefore(), parseResult) != false)) break;
        }
        expr = parseResult.exprs;
        var13_24 = expr.length;
        for (var14_26 = 0; !(var14_26 >= var13_24 || (expr = expr[var14_26]) instanceof UnparsedLiteral && (unparsedLiteral = (UnparsedLiteral)expr).multipleWarning()); ++var14_26) {
        }
        log.printLog();
        if (this.doSimplification && element instanceof Simplifiable) {
            simplifiable = (Simplifiable)element;
            var13_25 = simplifiable.simplify();
            return (T)var13_25;
        }
        var12_21 = element;
        return var12_21;
    }

    private static boolean checkRestrictedEvents(SyntaxElement element, ParseResult parseResult) {
        if (element instanceof EventRestrictedSyntax) {
            EventRestrictedSyntax eventRestrictedSyntax = (EventRestrictedSyntax)((Object)element);
            Class<? extends Event>[] supportedEvents = eventRestrictedSyntax.supportedEvents();
            if (!SkriptParser.getParser().isCurrentEvent(supportedEvents)) {
                Skript.error("'" + parseResult.expr + "' can only be used in " + SkriptParser.supportedEventsNames(supportedEvents));
                return false;
            }
        }
        return true;
    }

    @NotNull
    private static String supportedEventsNames(Class<? extends Event>[] supportedEvents) {
        ArrayList<String> names = new ArrayList<String>();
        for (SkriptEventInfo<?> eventInfo : Skript.getEvents()) {
            for (Class<? extends Event> eventClass : supportedEvents) {
                for (Class<? extends Event> event : eventInfo.events) {
                    if (!event.isAssignableFrom(eventClass)) continue;
                    names.add("the %s event".formatted(eventInfo.getName().toLowerCase()));
                }
            }
        }
        return StringUtils.join(names, ", ", " or ");
    }

    private static <T extends SyntaxElement> boolean checkExperimentalSyntax(T element) {
        if (!(element instanceof ExperimentalSyntax)) {
            return true;
        }
        ExperimentalSyntax experimentalSyntax = (ExperimentalSyntax)element;
        ExperimentSet experiments = SkriptParser.getParser().getExperimentSet();
        return experimentalSyntax.isSatisfiedBy(experiments);
    }

    @NotNull
    private static DefaultExpression<?> getDefaultExpression(ExprInfo exprInfo, String pattern) {
        DefaultValueData data = SkriptParser.getParser().getData(DefaultValueData.class);
        DefaultExpression<?> expr = data.getDefaultValue(exprInfo.classes[0].getC());
        if (expr == null) {
            expr = exprInfo.classes[0].getDefaultExpression();
        }
        if (expr == null) {
            throw new SkriptAPIException("The class '" + exprInfo.classes[0].getCodeName() + "' does not provide a default expression. Either allow null (with %-" + exprInfo.classes[0].getCodeName() + "%) or make it mandatory [pattern: " + pattern + "]");
        }
        if (!(expr instanceof Literal) && (exprInfo.flagMask & 1) == 0) {
            throw new SkriptAPIException("The default expression of '" + exprInfo.classes[0].getCodeName() + "' is not a literal. Either allow null (with %-*" + exprInfo.classes[0].getCodeName() + "%) or make it mandatory [pattern: " + pattern + "]");
        }
        if (expr instanceof Literal && (exprInfo.flagMask & 2) == 0) {
            throw new SkriptAPIException("The default expression of '" + exprInfo.classes[0].getCodeName() + "' is a literal. Either allow null (with %-~" + exprInfo.classes[0].getCodeName() + "%) or make it mandatory [pattern: " + pattern + "]");
        }
        if (!exprInfo.isPlural[0] && !expr.isSingle()) {
            throw new SkriptAPIException("The default expression of '" + exprInfo.classes[0].getCodeName() + "' is not a single-element expression. Change your pattern to allow multiple elements or make the expression mandatory [pattern: " + pattern + "]");
        }
        if (exprInfo.time != 0 && !expr.setTime(exprInfo.time)) {
            throw new SkriptAPIException("The default expression of '" + exprInfo.classes[0].getCodeName() + "' does not have distinct time states. [pattern: " + pattern + "]");
        }
        return expr;
    }

    @Nullable
    private static <T> Variable<T> parseVariable(String expr, Class<? extends T>[] returnTypes) {
        if (VARIABLE_PATTERN.matcher(expr).matches()) {
            String variableName = expr.substring(expr.indexOf(123) + 1, expr.lastIndexOf(125));
            boolean inExpression = false;
            int variableDepth = 0;
            for (char character : variableName.toCharArray()) {
                if (character == '%' && variableDepth == 0) {
                    boolean bl = inExpression = !inExpression;
                }
                if (inExpression) {
                    if (character == '{') {
                        ++variableDepth;
                    } else if (character == '}') {
                        --variableDepth;
                    }
                }
                if (inExpression || character != '{' && character != '}') continue;
                return null;
            }
            return Variable.newInstance(variableName, returnTypes);
        }
        return null;
    }

    @Nullable
    private static Expression<?> parseExpression(Class<?>[] types, String expr) {
        if (expr.startsWith("\u201c") || expr.startsWith("\u201d") || expr.endsWith("\u201d") || expr.endsWith("\u201c")) {
            Skript.error("Pretty quotes are not allowed, change to regular quotes (\")");
            return null;
        }
        if (expr.startsWith("\"") && expr.length() != 1 && SkriptParser.nextQuote(expr, 1) == expr.length() - 1) {
            return VariableString.newInstance(expr.substring(1, expr.length() - 1));
        }
        CheckedIterator<DefaultSyntaxInfos.Expression> iterator = new CheckedIterator<DefaultSyntaxInfos.Expression>(Skript.instance().syntaxRegistry().syntaxes(SyntaxRegistry.EXPRESSION).iterator(), info -> {
            if (info == null || info.returnType() == Object.class) {
                return true;
            }
            for (Class returnType : types) {
                assert (returnType != null);
                if (!Converters.converterExists(info.returnType(), returnType)) continue;
                return true;
            }
            return false;
        });
        return (Expression)SkriptParser.parse(expr, iterator, null);
    }

    @Nullable
    private <T> Expression<? extends T> parseSingleExpr(boolean allowUnparsedLiteral, @Nullable LogEntry error, Class<? extends T> ... types) {
        assert (types.length > 0);
        assert (types.length == 1 || !CollectionUtils.contains(types, Object.class));
        if (this.expr.isEmpty()) {
            return null;
        }
        if (this.context != ParseContext.COMMAND && this.context != ParseContext.PARSE && this.expr.startsWith("(") && this.expr.endsWith(")") && SkriptParser.next(this.expr, 0, this.context) == this.expr.length()) {
            return new SkriptParser(this, this.expr.substring(1, this.expr.length() - 1)).parseSingleExpr(allowUnparsedLiteral, error, types);
        }
        try (ParseLogHandler log = SkriptLogger.startParseLogHandler();){
            Expression<?> parsedExpression;
            if (this.context == ParseContext.DEFAULT || this.context == ParseContext.EVENT) {
                Variable<? extends T> parsedVariable = SkriptParser.parseVariable(this.expr, types);
                if (parsedVariable != null) {
                    if ((this.flags & 1) == 0) {
                        Skript.error("Variables cannot be used here.");
                        log.printError();
                        Expression<? extends T> expression = null;
                        return expression;
                    }
                    log.printLog();
                    Variable<? extends T> variable = parsedVariable;
                    return variable;
                }
                if (log.hasError()) {
                    log.printError();
                    Expression<? extends T> expression = null;
                    return expression;
                }
                FunctionReference<? extends T> functionReference = this.parseFunction(types);
                if (functionReference != null) {
                    log.printLog();
                    ExprFunctionCall<? extends T> exprFunctionCall = new ExprFunctionCall<T>(functionReference);
                    return exprFunctionCall;
                }
                if (log.hasError()) {
                    log.printError();
                    Expression<? extends T> expression = null;
                    return expression;
                }
            }
            log.clear();
            if ((this.flags & 1) != 0) {
                parsedExpression = SkriptParser.parseExpression(types, this.expr);
                if (parsedExpression != null) {
                    Class<?> parsedReturnType = parsedExpression.getReturnType();
                    for (Class<T> clazz : types) {
                        if (!clazz.isAssignableFrom(parsedReturnType)) continue;
                        log.printLog();
                        Expression<?> expression = parsedExpression;
                        return expression;
                    }
                    Class<? extends T>[] objTypes = types;
                    Expression<? extends T> convertedExpression = parsedExpression.getConvertedExpression(objTypes);
                    if (convertedExpression != null) {
                        log.printLog();
                        Expression<? extends T> expression = convertedExpression;
                        return expression;
                    }
                    log.printError(parsedExpression.toString(null, false) + " " + Language.get("is") + " " + SkriptParser.notOfType(types), ErrorQuality.NOT_AN_EXPRESSION);
                    Expression<? extends T> expression = null;
                    return expression;
                }
                log.clear();
            }
            if ((this.flags & 2) == 0) {
                log.printError();
                parsedExpression = null;
                return parsedExpression;
            }
            if (types[0] == Object.class) {
                if (!allowUnparsedLiteral || Classes.parseSimple(this.expr, Object.class, this.context) == null) {
                    log.printError();
                    parsedExpression = null;
                    return parsedExpression;
                }
                log.clear();
                LogEntry logError = log.getError();
                UnparsedLiteral unparsedLiteral = new UnparsedLiteral(this.expr, logError != null && (error == null || logError.quality > error.quality) ? logError : error);
                return unparsedLiteral;
            }
            for (Class<? extends T> type : types) {
                log.clear();
                assert (type != null);
                T parsedObject = Classes.parse(this.expr, type, this.context);
                if (parsedObject == null) continue;
                log.printLog();
                SimpleLiteral<T> simpleLiteral = new SimpleLiteral<T>(parsedObject, false);
                return simpleLiteral;
            }
            log.printError();
            Class<? extends T>[] classArray = null;
            return classArray;
        }
    }

    @Nullable
    private Expression<?> parseSingleExpr(boolean allowUnparsedLiteral, @Nullable LogEntry error, ExprInfo exprInfo) {
        if (this.expr.isEmpty()) {
            return null;
        }
        if (this.context != ParseContext.COMMAND && this.context != ParseContext.PARSE && this.expr.startsWith("(") && this.expr.endsWith(")") && SkriptParser.next(this.expr, 0, this.context) == this.expr.length()) {
            return new SkriptParser(this, this.expr.substring(1, this.expr.length() - 1)).parseSingleExpr(allowUnparsedLiteral, error, exprInfo);
        }
        try (ParseLogHandler log = SkriptLogger.startParseLogHandler();){
            String unparsedClassInfo;
            String object;
            Expression<?> result;
            Object classInfoMatcher;
            Expression<?> parsedExpression;
            boolean onlySingular;
            Class[] types = new Class[exprInfo.classes.length];
            boolean hasSingular = false;
            boolean hasPlural = false;
            Class[] nonNullTypes = new Class[exprInfo.classes.length];
            int nonNullIndex = 0;
            for (int i = 0; i < types.length; ++i) {
                if ((this.flags & exprInfo.flagMask) == 0) continue;
                if (exprInfo.isPlural[i]) {
                    hasPlural = true;
                } else {
                    hasSingular = true;
                }
                types[i] = exprInfo.classes[i].getC();
                nonNullTypes[nonNullIndex] = types[i];
                ++nonNullIndex;
            }
            boolean onlyPlural = !hasSingular && hasPlural;
            boolean bl = onlySingular = hasSingular && !hasPlural;
            if (this.context == ParseContext.DEFAULT || this.context == ParseContext.EVENT) {
                if (onlySingular || onlyPlural) {
                    parsedVariable = SkriptParser.parseVariable(this.expr, nonNullTypes);
                    if (parsedVariable != null) {
                        if ((this.flags & 1) == 0) {
                            Skript.error("Variables cannot be used here.");
                            log.printError();
                            Expression<?> expression = null;
                            return expression;
                        }
                        if (hasSingular && !parsedVariable.isSingle()) {
                            Skript.error("'" + this.expr + "' can only be a single " + Classes.toString(Stream.of(exprInfo.classes).map(classInfo -> classInfo.getName().toString()).toArray(), false) + ", not more.");
                            log.printError();
                            Expression<?> expression = null;
                            return expression;
                        }
                        log.printLog();
                        Variable variable = parsedVariable;
                        return variable;
                    }
                    if (log.hasError()) {
                        log.printError();
                        Expression<?> expression = null;
                        return expression;
                    }
                } else {
                    parsedVariable = SkriptParser.parseVariable(this.expr, types);
                    if (parsedVariable != null) {
                        if ((this.flags & 1) == 0) {
                            Skript.error("Variables cannot be used here.");
                            log.printError();
                            Expression<?> expression = null;
                            return expression;
                        }
                        if ((exprInfo.classes.length == 1 && !exprInfo.isPlural[0] || Booleans.contains((boolean[])exprInfo.isPlural, (boolean)true)) && !parsedVariable.isSingle()) {
                            Skript.error("'" + this.expr + "' can only be a single " + Classes.toString(Stream.of(exprInfo.classes).map(classInfo -> classInfo.getName().toString()).toArray(), false) + ", not more.");
                            log.printError();
                            Expression<?> expression = null;
                            return expression;
                        }
                        log.printLog();
                        Variable variable = parsedVariable;
                        return variable;
                    }
                    if (log.hasError()) {
                        log.printError();
                        Expression<?> expression = null;
                        return expression;
                    }
                }
                FunctionReference functionReference = this.parseFunction(types);
                if (functionReference != null) {
                    if (onlySingular && !functionReference.isSingle()) {
                        Skript.error("'" + this.expr + "' can only be a single " + Classes.toString(Stream.of(exprInfo.classes).map(classInfo -> classInfo.getName().toString()).toArray(), false) + ", not more.");
                        log.printError();
                        Expression<?> expression = null;
                        return expression;
                    }
                    log.printLog();
                    ExprFunctionCall exprFunctionCall = new ExprFunctionCall(functionReference);
                    return exprFunctionCall;
                }
                if (log.hasError()) {
                    log.printError();
                    Expression<?> expression = null;
                    return expression;
                }
            }
            log.clear();
            if ((this.flags & 1) != 0) {
                parsedExpression = SkriptParser.parseExpression(types, this.expr);
                if (parsedExpression != null) {
                    Object type;
                    Class<?> clazz = parsedExpression.getReturnType();
                    for (int i = 0; i < types.length; ++i) {
                        type = types[i];
                        if (type == null || !((Class)type).isAssignableFrom(clazz)) continue;
                        if (!exprInfo.isPlural[i] && !parsedExpression.isSingle()) {
                            if (this.context == ParseContext.COMMAND) {
                                Skript.error(Commands.m_too_many_arguments.toString(exprInfo.classes[i].getName().getIndefiniteArticle(), exprInfo.classes[i].getName().toString()), ErrorQuality.SEMANTIC_ERROR);
                            } else {
                                Skript.error("'" + this.expr + "' can only be a single " + Classes.toString(Stream.of(exprInfo.classes).map(classInfo -> classInfo.getName().toString()).toArray(), false) + ", not more.");
                            }
                            log.printError();
                            Expression<?> expression = null;
                            return expression;
                        }
                        log.printLog();
                        Expression<?> expression = parsedExpression;
                        return expression;
                    }
                    if (onlySingular && !parsedExpression.isSingle()) {
                        Skript.error("'" + this.expr + "' can only be a single " + Classes.toString(Stream.of(exprInfo.classes).map(classInfo -> classInfo.getName().toString()).toArray(), false) + ", not more.");
                        log.printError();
                        Expression<?> i = null;
                        return i;
                    }
                    Expression convertedExpression = parsedExpression.getConvertedExpression(types);
                    if (convertedExpression != null) {
                        log.printLog();
                        type = convertedExpression;
                        return type;
                    }
                    log.printError(parsedExpression.toString(null, false) + " " + Language.get("is") + " " + SkriptParser.notOfType(types), ErrorQuality.NOT_AN_EXPRESSION);
                    type = null;
                    return type;
                }
                log.clear();
            }
            if ((this.flags & 2) == 0) {
                log.printError();
                parsedExpression = null;
                return parsedExpression;
            }
            if (this.expr.endsWith(")") && this.expr.indexOf("(") != -1 && ((Matcher)(classInfoMatcher = LITERAL_SPECIFICATION_PATTERN.matcher(this.expr))).matches() && (result = this.parseSpecifiedLiteral(object = ((Matcher)classInfoMatcher).group("literal"), unparsedClassInfo = Noun.stripDefiniteArticle(((Matcher)classInfoMatcher).group("classinfo")), types)) != null) {
                log.printLog();
                Expression<?> expression = result;
                return expression;
            }
            if (exprInfo.classes.length == 1 && exprInfo.classes[0].getC() == Object.class) {
                if (!allowUnparsedLiteral) {
                    log.printError();
                    classInfoMatcher = null;
                    return classInfoMatcher;
                }
                classInfoMatcher = this.getUnparsedLiteral(log, error);
                return classInfoMatcher;
            }
            boolean containsObjectClass = false;
            for (ClassInfo<?> classInfo2 : exprInfo.classes) {
                log.clear();
                assert (classInfo2.getC() != null);
                if (classInfo2.getC().equals(Object.class)) {
                    containsObjectClass = true;
                    continue;
                }
                Object parsedObject = Classes.parse(this.expr, classInfo2.getC(), this.context);
                if (parsedObject == null) continue;
                log.printLog();
                SimpleLiteral simpleLiteral = new SimpleLiteral(parsedObject, false, new UnparsedLiteral(this.expr));
                return simpleLiteral;
            }
            if (allowUnparsedLiteral && containsObjectClass) {
                UnparsedLiteral unparsedLiteral = this.getUnparsedLiteral(log, error);
                return unparsedLiteral;
            }
            if (this.expr.startsWith("\"") && this.expr.endsWith("\"") && this.expr.length() > 1) {
                for (ClassInfo<?> aClass : exprInfo.classes) {
                    if (!aClass.getC().isAssignableFrom(String.class)) continue;
                    VariableString string = VariableString.newInstance(this.expr.substring(1, this.expr.length() - 1));
                    if (!(string instanceof LiteralString)) break;
                    VariableString variableString = string;
                    return variableString;
                }
            }
            log.printError();
            Expression<?> expression = null;
            return expression;
        }
    }

    @Nullable
    private UnparsedLiteral getUnparsedLiteral(ParseLogHandler log, @Nullable LogEntry error) {
        if (Classes.parseSimple(this.expr, Object.class, this.context) == null) {
            log.printError();
            return null;
        }
        log.clear();
        LogEntry logError = log.getError();
        return new UnparsedLiteral(this.expr, logError != null && (error == null || logError.quality > error.quality) ? logError : error);
    }

    @Nullable
    private Expression<?> parseSpecifiedLiteral(String literalString, String unparsedClassInfo, Class<?> ... types) {
        ClassInfo classInfo = Classes.parse(unparsedClassInfo, ClassInfo.class, this.context);
        if (classInfo == null) {
            Skript.error("A " + unparsedClassInfo + " is not a valid type.");
            return null;
        }
        Parser classInfoParser = classInfo.getParser();
        if (classInfoParser == null || !classInfoParser.canParse(this.context)) {
            Skript.error("A " + unparsedClassInfo + " cannot be parsed.");
            return null;
        }
        if (!this.checkAcceptedType(classInfo.getC(), types)) {
            Skript.error(this.expr + " " + Language.get("is") + " " + SkriptParser.notOfType(types));
            return null;
        }
        Object parsedObject = classInfoParser.parse(literalString, this.context);
        if (parsedObject != null) {
            return new SimpleLiteral(parsedObject, false, new UnparsedLiteral(literalString));
        }
        return null;
    }

    private boolean checkAcceptedType(Class<?> clazz, Class<?> ... types) {
        for (Class<?> targetType : types) {
            if (!targetType.isAssignableFrom(clazz)) continue;
            return true;
        }
        return false;
    }

    private SkriptParser suppressMissingAndOrWarnings() {
        this.suppressMissingAndOrWarnings = true;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public <T> Expression<? extends T> parseExpression(Class<? extends T> ... types) {
        if (this.expr.length() == 0) {
            return null;
        }
        assert (types.length > 0);
        assert (types.length == 1 || !CollectionUtils.contains(types, Object.class));
        ParseLogHandler log = SkriptLogger.startParseLogHandler();
        try {
            Expression<? extends T> parsedExpression = this.parseSingleExpr(true, null, types);
            if (parsedExpression != null) {
                log.printLog();
                Expression<? extends T> expression = parsedExpression;
                return expression;
            }
            log.clear();
            Expression<? extends T> expression = this.parseExpressionList(log, types);
            return expression;
        }
        finally {
            log.stop();
        }
    }

    @Nullable
    private <T> Expression<? extends T> parseExpressionList(ParseLogHandler log, Class<? extends T> ... types) {
        int last;
        boolean isObject = types.length == 1 && types[0] == Object.class;
        ArrayList<Expression<? extends T>> parsedExpressions = new ArrayList<Expression<? extends T>>();
        Kleenean and = Kleenean.UNKNOWN;
        boolean isLiteralList = true;
        ArrayList<int[]> pieces = new ArrayList<int[]>();
        Matcher matcher = LIST_SPLIT_PATTERN.matcher(this.expr);
        int i = 0;
        int j = 0;
        while (i >= 0 && i <= this.expr.length()) {
            if (i == this.expr.length() || matcher.region(i, this.expr.length()).lookingAt()) {
                pieces.add(new int[]{j, i});
                if (i == this.expr.length()) break;
                j = i = matcher.end();
            }
            i = SkriptParser.next(this.expr, i, this.context);
        }
        if (i != this.expr.length()) {
            assert (i == -1 && this.context != ParseContext.COMMAND && this.context != ParseContext.PARSE) : i + "; " + this.expr;
            log.printError("Invalid brackets/variables/text in '" + this.expr + "'", ErrorQuality.NOT_AN_EXPRESSION);
            return null;
        }
        if (pieces.size() == 1) {
            if (this.expr.startsWith("(") && this.expr.endsWith(")") && SkriptParser.next(this.expr, 0, this.context) == this.expr.length()) {
                log.clear();
                return new SkriptParser(this, this.expr.substring(1, this.expr.length() - 1)).parseExpression(types);
            }
            if (isObject && (this.flags & 2) != 0) {
                log.clear();
                return new UnparsedLiteral(this.expr, log.getError());
            }
            log.printError();
            return null;
        }
        block1: for (int first = 0; first < pieces.size(); first += last) {
            for (last = 1; last <= pieces.size() - first; ++last) {
                boolean or;
                String delimiter;
                if (first == 0 && last == pieces.size()) continue;
                int start = ((int[])pieces.get(first))[0];
                int end = ((int[])pieces.get(first + last - 1))[1];
                String subExpr = this.expr.substring(start, end).trim();
                assert (subExpr.length() < this.expr.length()) : subExpr;
                Expression<? extends T> parsedExpression = subExpr.startsWith("(") && subExpr.endsWith(")") && SkriptParser.next(subExpr, 0, this.context) == subExpr.length() ? new SkriptParser(this, subExpr).parseExpression(types) : new SkriptParser(this, subExpr).parseSingleExpr(last == 1, log.getError(), types);
                if (parsedExpression == null) continue;
                isLiteralList &= parsedExpression instanceof Literal;
                parsedExpressions.add(parsedExpression);
                if (first == 0 || (delimiter = this.expr.substring(((int[])pieces.get(first - 1))[1], start).trim().toLowerCase(Locale.ENGLISH)).equals(",")) continue block1;
                boolean bl = or = !delimiter.contains("nor") && delimiter.endsWith("or");
                if (and.isUnknown()) {
                    and = Kleenean.get(!or);
                    continue block1;
                }
                if (and == Kleenean.get(!or)) continue block1;
                Skript.warning("List has multiple 'and' or 'or', will default to 'and'. Use brackets if you want to define multiple lists. List: " + this.expr);
                and = Kleenean.TRUE;
                continue block1;
            }
            log.printError();
            return null;
        }
        log.printLog(false);
        if (parsedExpressions.size() == 1) {
            return (Expression)parsedExpressions.get(0);
        }
        if (and.isUnknown() && !this.suppressMissingAndOrWarnings) {
            Script currentScript;
            ParserInstance parser = SkriptParser.getParser();
            Script script = currentScript = parser.isActive() ? parser.getCurrentScript() : null;
            if (currentScript == null || !currentScript.suppressesWarning(ScriptWarning.MISSING_CONJUNCTION)) {
                Skript.warning("List is missing 'and' or 'or', defaulting to 'and': " + this.expr);
            }
        }
        Class[] exprReturnTypes = new Class[parsedExpressions.size()];
        for (i = 0; i < parsedExpressions.size(); ++i) {
            exprReturnTypes[i] = ((Expression)parsedExpressions.get(i)).getReturnType();
        }
        if (isLiteralList) {
            Literal[] literals = parsedExpressions.toArray(new Literal[0]);
            return new LiteralList(literals, Classes.getSuperClassInfo(exprReturnTypes).getC(), exprReturnTypes, !and.isFalse());
        }
        Expression[] expressions = parsedExpressions.toArray(new Expression[0]);
        return new ExpressionList(expressions, Classes.getSuperClassInfo(exprReturnTypes).getC(), exprReturnTypes, !and.isFalse());
    }

    @Nullable
    public Expression<?> parseExpression(ExprInfo exprInfo) {
        if (this.expr.length() == 0) {
            return null;
        }
        boolean isObject = exprInfo.classes.length == 1 && exprInfo.classes[0].getC() == Object.class;
        try (ParseLogHandler log = SkriptLogger.startParseLogHandler();){
            int last2;
            Expression<?> parsedExpression = this.parseSingleExpr(true, null, exprInfo);
            if (parsedExpression != null) {
                log.printLog();
                Expression<?> expression = parsedExpression;
                return expression;
            }
            log.clear();
            ArrayList parsedExpressions = new ArrayList();
            Kleenean and = Kleenean.UNKNOWN;
            boolean isLiteralList = true;
            ArrayList<int[]> pieces = new ArrayList<int[]>();
            Expression<?> matcher = LIST_SPLIT_PATTERN.matcher(this.expr);
            int i = 0;
            int j = 0;
            while (i >= 0 && i <= this.expr.length()) {
                if (i == this.expr.length() || ((Matcher)((Object)matcher)).region(i, this.expr.length()).lookingAt()) {
                    pieces.add(new int[]{j, i});
                    if (i == this.expr.length()) break;
                    j = i = ((Matcher)((Object)matcher)).end();
                }
                i = SkriptParser.next(this.expr, i, this.context);
            }
            if (i != this.expr.length()) {
                assert (i == -1 && this.context != ParseContext.COMMAND && this.context != ParseContext.PARSE) : i + "; " + this.expr;
                log.printError("Invalid brackets/variables/text in '" + this.expr + "'", ErrorQuality.NOT_AN_EXPRESSION);
                Expression<?> expression = null;
                return expression;
            }
            if (pieces.size() == 1) {
                if (this.expr.startsWith("(") && this.expr.endsWith(")") && SkriptParser.next(this.expr, 0, this.context) == this.expr.length()) {
                    log.clear();
                    matcher = new SkriptParser(this, this.expr.substring(1, this.expr.length() - 1)).parseExpression(exprInfo);
                    return matcher;
                }
                if (isObject && (this.flags & 2) != 0) {
                    log.clear();
                    matcher = new UnparsedLiteral(this.expr, log.getError());
                    return matcher;
                }
                log.printError();
                matcher = null;
                return matcher;
            }
            if (!exprInfo.isPlural[0] && !OR_PATTERN.matcher(this.expr).find()) {
                log.printError();
                matcher = null;
                return matcher;
            }
            block16: for (int first = 0; first < pieces.size(); first += last2) {
                for (last2 = 1; last2 <= pieces.size() - first; ++last2) {
                    boolean or;
                    String delimiter;
                    if (first == 0 && last2 == pieces.size()) continue;
                    int start = ((int[])pieces.get(first))[0];
                    int end = ((int[])pieces.get(first + last2 - 1))[1];
                    String subExpr = this.expr.substring(start, end).trim();
                    assert (subExpr.length() < this.expr.length()) : subExpr;
                    parsedExpression = subExpr.startsWith("(") && subExpr.endsWith(")") && SkriptParser.next(subExpr, 0, this.context) == subExpr.length() ? new SkriptParser(this, subExpr).parseExpression(exprInfo) : new SkriptParser(this, subExpr).parseSingleExpr(last2 == 1, log.getError(), exprInfo);
                    if (parsedExpression == null) continue;
                    isLiteralList &= parsedExpression instanceof Literal;
                    parsedExpressions.add(parsedExpression);
                    if (first == 0 || (delimiter = this.expr.substring(((int[])pieces.get(first - 1))[1], start).trim().toLowerCase(Locale.ENGLISH)).equals(",")) continue block16;
                    boolean bl = or = !delimiter.contains("nor") && delimiter.endsWith("or");
                    if (and.isUnknown()) {
                        and = Kleenean.get(!or);
                        continue block16;
                    }
                    if (and != Kleenean.get(or)) continue block16;
                    Skript.warning("List has multiple 'and' or 'or', will default to 'and'. Use brackets if you want to define multiple lists. List: " + this.expr);
                    and = Kleenean.TRUE;
                    continue block16;
                }
                log.printError();
                Expression<?> last2 = null;
                return last2;
            }
            if (!exprInfo.isPlural[0] && !and.isFalse()) {
                log.printError();
                Expression<?> first = null;
                return first;
            }
            log.printLog(false);
            if (parsedExpressions.size() == 1) {
                Expression first = (Expression)parsedExpressions.get(0);
                return first;
            }
            if (and.isUnknown() && !this.suppressMissingAndOrWarnings) {
                Script currentScript;
                ParserInstance parser = SkriptParser.getParser();
                Script script = currentScript = parser.isActive() ? parser.getCurrentScript() : null;
                if (currentScript == null || !currentScript.suppressesWarning(ScriptWarning.MISSING_CONJUNCTION)) {
                    Skript.warning("List is missing 'and' or 'or', defaulting to 'and': " + this.expr);
                }
            }
            Class[] exprReturnTypes = new Class[parsedExpressions.size()];
            for (i = 0; i < parsedExpressions.size(); ++i) {
                exprReturnTypes[i] = ((Expression)parsedExpressions.get(i)).getReturnType();
            }
            if (isLiteralList) {
                Literal[] literals = parsedExpressions.toArray(new Literal[parsedExpressions.size()]);
                LiteralList literalList = new LiteralList(literals, Classes.getSuperClassInfo(exprReturnTypes).getC(), exprReturnTypes, !and.isFalse());
                return literalList;
            }
            Expression[] expressions = parsedExpressions.toArray(new Expression[parsedExpressions.size()]);
            ExpressionList expressionList = new ExpressionList(expressions, Classes.getSuperClassInfo(exprReturnTypes).getC(), exprReturnTypes, !and.isFalse());
            return expressionList;
        }
    }

    @Nullable
    public <T> FunctionReference<T> parseFunction(Class<? extends T> ... types) {
        if (this.context != ParseContext.DEFAULT && this.context != ParseContext.EVENT) {
            return null;
        }
        AtomicBoolean unaryArgument = new AtomicBoolean(false);
        try (ParseLogHandler log = SkriptLogger.startParseLogHandler();){
            FunctionReference<T> functionReference;
            FunctionReference<T> functionReference2;
            block26: {
                Matcher matcher = FUNCTION_CALL_PATTERN.matcher(this.expr);
                if (!matcher.matches()) {
                    log.printLog();
                    FunctionReference<T> functionReference3 = null;
                    return functionReference3;
                }
                String functionName = matcher.group(1);
                String args = matcher.group(2);
                int i2 = 0;
                while (i2 < args.length()) {
                    if (i2 == -1) {
                        log.printLog();
                        FunctionReference<T> functionReference4 = null;
                        return functionReference4;
                    }
                    i2 = SkriptParser.next(args, i2, this.context);
                }
                if ((this.flags & 1) == 0) {
                    Skript.error("Functions cannot be used here (or there is a problem with your arguments).");
                    log.printError();
                    FunctionReference<T> i2 = null;
                    return i2;
                }
                SkriptParser skriptParser = new SkriptParser(args, this.flags | 2, this.context);
                Expression<?>[] params = this.getFunctionArguments(() -> skriptParser.suppressMissingAndOrWarnings().parseExpression(Object.class), args, unaryArgument);
                if (params == null) {
                    log.printError();
                    FunctionReference<T> functionReference5 = null;
                    return functionReference5;
                }
                ParserInstance parser = SkriptParser.getParser();
                Script currentScript = parser.isActive() ? parser.getCurrentScript() : null;
                functionReference2 = new FunctionReference<T>(functionName, SkriptLogger.getNode(), currentScript != null ? currentScript.getConfig().getFileName() : null, types, params);
                if (unaryArgument.get() && !functionReference2.validateParameterArity(true)) {
                    block25: {
                        try (ParseLogHandler ignored = SkriptLogger.startParseLogHandler();){
                            SkriptParser alternative = new SkriptParser(args, this.flags | 2, this.context);
                            params = this.getFunctionArguments(() -> alternative.suppressMissingAndOrWarnings().parseExpressionList(ignored, Object.class), args, unaryArgument);
                            ignored.clear();
                            if (params != null) break block25;
                            break block26;
                        }
                    }
                    functionReference2 = new FunctionReference<T>(functionName, SkriptLogger.getNode(), currentScript != null ? currentScript.getConfig().getFileName() : null, types, params);
                }
            }
            if (!functionReference2.validateFunction(true)) {
                log.printError();
                functionReference = null;
                return functionReference;
            }
            log.printLog();
            functionReference = functionReference2;
            return functionReference;
        }
    }

    private Expression<?> @Nullable [] getFunctionArguments(Supplier<Expression<?>> parsing, String args, AtomicBoolean unary) {
        Expression[] params;
        if (args.length() != 0) {
            Expression<?> parsedExpression = parsing.get();
            if (parsedExpression == null) {
                return null;
            }
            if (parsedExpression instanceof ExpressionList) {
                if (!parsedExpression.getAnd()) {
                    Skript.error("Function arguments must be separated by commas and optionally an 'and', but not an 'or'. Put the 'or' into a second set of parentheses if you want to make it a single parameter, e.g. 'give(player, (sword or axe))'");
                    return null;
                }
                params = ((ExpressionList)parsedExpression).getExpressions();
            } else {
                unary.set(true);
                params = new Expression[]{parsedExpression};
            }
        } else {
            params = new Expression[]{};
        }
        return params;
    }

    public static boolean parseArguments(String args, ScriptCommand command, ScriptCommandEvent event) {
        SkriptParser parser = new SkriptParser(args, 2, ParseContext.COMMAND);
        ParseResult parseResult = parser.parse_i(command.getPattern());
        if (parseResult == null) {
            return false;
        }
        List<Argument<?>> arguments = command.getArguments();
        assert (arguments.size() == parseResult.exprs.length);
        for (int i = 0; i < parseResult.exprs.length; ++i) {
            if (parseResult.exprs[i] == null) {
                arguments.get(i).setToDefault(event);
                continue;
            }
            arguments.get(i).set(event, parseResult.exprs[i].getArray(event));
        }
        return true;
    }

    @Nullable
    public static ParseResult parse(String text, String pattern) {
        return new SkriptParser(text, 2, ParseContext.COMMAND).parse_i(pattern);
    }

    @Nullable
    public static ParseResult parse(String text, String pattern, int parseFlags, ParseContext parseContext) {
        return new SkriptParser(text, parseFlags, parseContext).parse_i(pattern);
    }

    @Nullable
    public static ParseResult parse(String text, SkriptPattern pattern, int parseFlags, ParseContext parseContext) {
        return SkriptParser.parse(text, pattern.toString(), parseFlags, parseContext);
    }

    public static int nextBracket(String pattern, char closingBracket, char openingBracket, int start, boolean isGroup) throws MalformedPatternException {
        int index = 0;
        for (int i = start; i < pattern.length(); ++i) {
            if (pattern.charAt(i) == '\\') {
                ++i;
                continue;
            }
            if (pattern.charAt(i) == closingBracket) {
                if (index == 0) {
                    if (!isGroup) {
                        throw new MalformedPatternException(pattern, "Unexpected closing bracket '" + closingBracket + "'");
                    }
                    return i;
                }
                --index;
                continue;
            }
            if (pattern.charAt(i) != openingBracket) continue;
            ++index;
        }
        if (isGroup) {
            throw new MalformedPatternException(pattern, "Missing closing bracket '" + closingBracket + "'");
        }
        return -1;
    }

    private static int nextUnescaped(String pattern, char character, int from) {
        for (int i = from; i < pattern.length(); ++i) {
            if (pattern.charAt(i) == '\\') {
                ++i;
                continue;
            }
            if (pattern.charAt(i) != character) continue;
            return i;
        }
        return -1;
    }

    static int countUnescaped(String haystack, char needle) {
        return SkriptParser.countUnescaped(haystack, needle, 0, haystack.length());
    }

    static int countUnescaped(String haystack, char needle, int start, int end) {
        assert (start >= 0 && start <= end && end <= haystack.length()) : start + ", " + end + "; " + haystack.length();
        int count = 0;
        for (int i = start; i < end; ++i) {
            char character = haystack.charAt(i);
            if (character == '\\') {
                ++i;
                continue;
            }
            if (character != needle) continue;
            ++count;
        }
        return count;
    }

    private static int nextQuote(String string, int start) {
        boolean inExpression = false;
        int length = string.length();
        for (int i = start; i < length; ++i) {
            char character = string.charAt(i);
            if (character == '\"' && !inExpression) {
                if (i == length - 1 || string.charAt(i + 1) != '\"') {
                    return i;
                }
                ++i;
                continue;
            }
            if (character != '%') continue;
            inExpression = !inExpression;
        }
        return -1;
    }

    public static String notOfType(Class<?> ... types) {
        if (types.length == 1) {
            Class<?> type = types[0];
            assert (type != null);
            return Language.get("not") + " " + Classes.getSuperClassInfo(type).getName().withIndefiniteArticle();
        }
        StringBuilder message = new StringBuilder(Language.get("neither") + " ");
        for (int i = 0; i < types.length; ++i) {
            if (i != 0) {
                if (i != types.length - 1) {
                    message.append(", ");
                } else {
                    message.append(" ").append(Language.get("nor")).append(" ");
                }
            }
            Class<?> c = types[i];
            assert (c != null);
            ClassInfo<?> classInfo = Classes.getSuperClassInfo(c);
            if (classInfo != null) {
                message.append(classInfo.getName().withIndefiniteArticle());
                continue;
            }
            message.append(c.getName());
        }
        return message.toString();
    }

    public static String notOfType(ClassInfo<?> ... types) {
        if (types.length == 1) {
            return Language.get("not") + " " + types[0].getName().withIndefiniteArticle();
        }
        StringBuilder message = new StringBuilder(Language.get("neither") + " ");
        for (int i = 0; i < types.length; ++i) {
            if (i != 0) {
                if (i != types.length - 1) {
                    message.append(", ");
                } else {
                    message.append(" ").append(Language.get("nor")).append(" ");
                }
            }
            message.append(types[i].getName().withIndefiniteArticle());
        }
        return message.toString();
    }

    public static int next(String expr, int startIndex, ParseContext context) {
        if (startIndex < 0) {
            throw new StringIndexOutOfBoundsException(startIndex);
        }
        int exprLength = expr.length();
        if (startIndex >= exprLength) {
            return -1;
        }
        if (context == ParseContext.COMMAND || context == ParseContext.PARSE) {
            return startIndex + 1;
        }
        switch (expr.charAt(startIndex)) {
            case '\"': {
                int index = SkriptParser.nextQuote(expr, startIndex + 1);
                return index < 0 ? -1 : index + 1;
            }
            case '{': {
                int index = VariableString.nextVariableBracket(expr, startIndex + 1);
                return index < 0 ? -1 : index + 1;
            }
            case '(': {
                int index = startIndex + 1;
                while (index >= 0 && index < exprLength) {
                    if (expr.charAt(index) == ')') {
                        return index + 1;
                    }
                    index = SkriptParser.next(expr, index, context);
                }
                return -1;
            }
        }
        return startIndex + 1;
    }

    public static int nextOccurrence(String haystack, String needle, int startIndex, ParseContext parseContext, boolean caseSensitive) {
        boolean startsWithSpecialChar;
        if (startIndex < 0) {
            throw new StringIndexOutOfBoundsException(startIndex);
        }
        if (parseContext == ParseContext.COMMAND || parseContext == ParseContext.PARSE) {
            return haystack.indexOf(needle, startIndex);
        }
        int haystackLength = haystack.length();
        if (startIndex >= haystackLength) {
            return -1;
        }
        int needleLength = needle.length();
        char firstChar = needle.charAt(0);
        boolean bl = startsWithSpecialChar = firstChar == '\"' || firstChar == '{' || firstChar == '(';
        while (startIndex < haystackLength) {
            char character = haystack.charAt(startIndex);
            if (startsWithSpecialChar && haystack.regionMatches(!caseSensitive, startIndex, needle, 0, needleLength)) {
                return startIndex;
            }
            switch (character) {
                case '\"': {
                    startIndex = SkriptParser.nextQuote(haystack, startIndex + 1);
                    if (startIndex >= 0) break;
                    return -1;
                }
                case '{': {
                    startIndex = VariableString.nextVariableBracket(haystack, startIndex + 1);
                    if (startIndex >= 0) break;
                    return -1;
                }
                case '(': {
                    startIndex = SkriptParser.next(haystack, startIndex, parseContext);
                    if (startIndex >= 0) break;
                    return -1;
                }
            }
            if (haystack.regionMatches(!caseSensitive, startIndex, needle, 0, needleLength)) {
                return startIndex;
            }
            ++startIndex;
        }
        return -1;
    }

    @Nullable
    private ParseResult parse_i(String pattern) {
        SkriptPattern skriptPattern = patterns.computeIfAbsent(pattern, PatternCompiler::compile);
        MatchResult matchResult = skriptPattern.match(this.expr, this.flags, this.context);
        if (matchResult == null) {
            return null;
        }
        return matchResult.toParseResult();
    }

    @Nullable
    public static NonNullPair<String, NonNullPair<ClassInfo<?>, Boolean>[]> validatePattern(String pattern) {
        ArrayList pairs = new ArrayList();
        int groupLevel = 0;
        int optionalLevel = 0;
        LinkedList<Character> groups = new LinkedList<Character>();
        StringBuilder stringBuilder = new StringBuilder(pattern.length());
        int last = 0;
        for (int i = 0; i < pattern.length(); ++i) {
            int j;
            char character = pattern.charAt(i);
            if (character == '(') {
                ++groupLevel;
                groups.addLast(Character.valueOf(character));
                continue;
            }
            if (character == '|') {
                if (groupLevel == 0 || ((Character)groups.peekLast()).charValue() != '(' && ((Character)groups.peekLast()).charValue() != '|') {
                    return SkriptParser.error("Cannot use the pipe character '|' outside of groups. Escape it if you want to match a literal pipe: '\\|'");
                }
                groups.removeLast();
                groups.addLast(Character.valueOf(character));
                continue;
            }
            if (character == ')') {
                if (groupLevel == 0 || ((Character)groups.peekLast()).charValue() != '(' && ((Character)groups.peekLast()).charValue() != '|') {
                    return SkriptParser.error("Unexpected closing group bracket ')'. Escape it if you want to match a literal bracket: '\\)'");
                }
                if (((Character)groups.peekLast()).charValue() == '(') {
                    return SkriptParser.error("(...|...) groups have to contain at least one pipe character '|' to separate it into parts. Escape the brackets if you want to match literal brackets: \"\\(not a group\\)\"");
                }
                --groupLevel;
                groups.removeLast();
                continue;
            }
            if (character == '[') {
                ++optionalLevel;
                groups.addLast(Character.valueOf(character));
                continue;
            }
            if (character == ']') {
                if (optionalLevel == 0 || ((Character)groups.peekLast()).charValue() != '[') {
                    return SkriptParser.error("Unexpected closing optional bracket ']'. Escape it if you want to match a literal bracket: '\\]'");
                }
                --optionalLevel;
                groups.removeLast();
                continue;
            }
            if (character == '<') {
                j = pattern.indexOf(62, i + 1);
                if (j == -1) {
                    return SkriptParser.error("Missing closing regex bracket '>'. Escape the '<' if you want to match a literal bracket: '\\<'");
                }
                try {
                    Pattern.compile(pattern.substring(i + 1, j));
                }
                catch (PatternSyntaxException e) {
                    return SkriptParser.error("Invalid Regular Expression '" + pattern.substring(i + 1, j) + "': " + e.getLocalizedMessage());
                }
                i = j;
                continue;
            }
            if (character == '>') {
                return SkriptParser.error("Unexpected closing regex bracket '>'. Escape it if you want to match a literal bracket: '\\>'");
            }
            if (character == '%') {
                j = pattern.indexOf(37, i + 1);
                if (j == -1) {
                    return SkriptParser.error("Missing end sign '%' of expression. Escape the percent sign to match a literal '%': '\\%'");
                }
                NonNullPair<String, Boolean> pair = Utils.getEnglishPlural(pattern.substring(i + 1, j));
                ClassInfo<?> classInfo = Classes.getClassInfoFromUserInput(pair.getFirst());
                if (classInfo == null) {
                    return SkriptParser.error("The type '" + pair.getFirst() + "' could not be found. Please check your spelling or escape the percent signs if you want to match literal %s: \"\\%not an expression\\%\"");
                }
                pairs.add(new NonNullPair(classInfo, pair.getSecond()));
                stringBuilder.append(pattern, last, i + 1);
                stringBuilder.append(Utils.toEnglishPlural(classInfo.getCodeName(), pair.getSecond()));
                last = j;
                i = j;
                continue;
            }
            if (character != '\\') continue;
            if (i == pattern.length() - 1) {
                return SkriptParser.error("Pattern must not end in an unescaped backslash. Add another backslash to escape it, or remove it altogether.");
            }
            ++i;
        }
        stringBuilder.append(pattern.substring(last));
        return new NonNullPair<String, NonNullPair<ClassInfo<?>, Boolean>[]>(stringBuilder.toString(), pairs.toArray(new NonNullPair[0]));
    }

    @Nullable
    private static NonNullPair<String, NonNullPair<ClassInfo<?>, Boolean>[]> error(String error) {
        Skript.error("Invalid pattern: " + error);
        return null;
    }

    public static boolean validateLine(String line) {
        if (StringUtils.count(line, '\"') % 2 != 0) {
            Skript.error(M_QUOTES_ERROR.toString());
            return false;
        }
        int i = 0;
        while (i < line.length()) {
            if (i == -1) {
                Skript.error(M_BRACKETS_ERROR.toString());
                return false;
            }
            i = SkriptParser.next(line, i, ParseContext.DEFAULT);
        }
        return true;
    }

    private static ParserInstance getParser() {
        return ParserInstance.get();
    }

    static {
        ParserInstance.registerData(DefaultValueData.class, DefaultValueData::new);
        listSplitPattern = LIST_SPLIT_PATTERN;
    }

    public static class ParseResult {
        @Nullable
        public SkriptPattern source;
        public Expression<?>[] exprs;
        public List<java.util.regex.MatchResult> regexes = new ArrayList<java.util.regex.MatchResult>(1);
        public String expr;
        public int mark = 0;
        public List<String> tags = new ArrayList<String>();

        public ParseResult(SkriptParser parser, String pattern) {
            this.expr = parser.expr;
            this.exprs = new Expression[SkriptParser.countUnescaped(pattern, '%') / 2];
        }

        public ParseResult(String expr, Expression<?>[] expressions) {
            this.expr = expr;
            this.exprs = expressions;
        }

        public boolean hasTag(String tag) {
            return this.tags.contains(tag);
        }
    }

    public static class ExprInfo {
        public final ClassInfo<?>[] classes;
        public final boolean[] isPlural;
        public boolean isOptional;
        public int flagMask = -1;
        public int time = 0;

        public ExprInfo(int length) {
            this.classes = new ClassInfo[length];
            this.isPlural = new boolean[length];
        }
    }
}

