/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.registrations;

import ch.njol.skript.SkriptAddon;
import ch.njol.skript.patterns.PatternCompiler;
import ch.njol.skript.patterns.SkriptPattern;
import org.skriptlang.skript.lang.experiment.Experiment;
import org.skriptlang.skript.lang.experiment.ExperimentRegistry;
import org.skriptlang.skript.lang.experiment.LifeCycle;

public enum Feature implements Experiment
{
    EXAMPLES("examples", LifeCycle.STABLE, new String[0]),
    QUEUES("queues", LifeCycle.EXPERIMENTAL, new String[0]),
    FOR_EACH_LOOPS("for loop", LifeCycle.EXPERIMENTAL, "for [each] loop[s]"),
    SCRIPT_REFLECTION("reflection", LifeCycle.EXPERIMENTAL, "[script] reflection"),
    CATCH_ERRORS("catch runtime errors", LifeCycle.EXPERIMENTAL, "error catching [section]"),
    TYPE_HINTS("type hints", LifeCycle.EXPERIMENTAL, "[local variable] type hints"),
    DAMAGE_SOURCE("damage source", LifeCycle.EXPERIMENTAL, "damage source[s]");

    private final String codeName;
    private final LifeCycle phase;
    private final SkriptPattern compiledPattern;

    private Feature(String codeName, LifeCycle phase, String ... patterns) {
        this.codeName = codeName;
        this.phase = phase;
        this.compiledPattern = switch (patterns.length) {
            case 0 -> PatternCompiler.compile(codeName);
            case 1 -> PatternCompiler.compile(patterns[0]);
            default -> PatternCompiler.compile("(" + String.join((CharSequence)"|", patterns) + ")");
        };
    }

    public static void registerAll(SkriptAddon addon, ExperimentRegistry manager) {
        for (Feature value : Feature.values()) {
            manager.register(addon, value);
        }
    }

    @Override
    public String codeName() {
        return this.codeName;
    }

    @Override
    public LifeCycle phase() {
        return this.phase;
    }

    @Override
    public SkriptPattern pattern() {
        return this.compiledPattern;
    }
}

