/*
 * Decompiled with CFR 0.152.
 */
package org.skriptlang.skript.bukkit.damagesource.elements;

import ch.njol.skript.Skript;
import ch.njol.skript.conditions.base.PropertyCondition;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Example;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.SyntaxStringBuilder;
import ch.njol.util.Kleenean;
import org.bukkit.damage.DamageSource;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;
import org.skriptlang.skript.bukkit.damagesource.DamageSourceExperimentSyntax;

@Name(value="Damage Source - Does Scale With Difficulty")
@Description(value={"Whether the damage from a damage source scales with the difficulty of the server."})
@Example(value="on death:\n\tif event-damage source scales damage with difficulty:\n")
@Since(value={"2.12"})
@RequiredPlugins(value={"Minecraft 1.20.4+"})
public class CondScalesWithDifficulty
extends PropertyCondition<DamageSource>
implements DamageSourceExperimentSyntax {
    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.setExpr(exprs[0]);
        this.setNegated(matchedPattern % 2 == 1);
        return true;
    }

    @Override
    public boolean check(DamageSource damageSource) {
        return damageSource.scalesWithDifficulty();
    }

    @Override
    protected String getPropertyName() {
        return "scales with difficulty";
    }

    @Override
    public String toString(@Nullable Event event, boolean debug) {
        SyntaxStringBuilder builder = new SyntaxStringBuilder(event, debug);
        builder.append((Object)this.getExpr());
        if (this.isNegated()) {
            builder.append((Object)"does not scale");
        } else {
            builder.append((Object)"scales");
        }
        builder.append((Object)"with difficulty");
        return builder.toString();
    }

    static {
        Skript.registerCondition(CondScalesWithDifficulty.class, "%damagesources% ((does|do) scale|scales) damage with difficulty", "%damagesources% (do not|don't|does not|doesn't) scale damage with difficulty", "%damagesources%'[s] damage ((does|do) scale|scales) with difficulty", "%damagesources%'[s] damage (do not|don't|does not|doesn't) scale with difficulty");
    }
}

