/*
 * Decompiled with CFR 0.152.
 */
package org.skriptlang.skript.bukkit.damagesource.elements;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Example;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import org.bukkit.damage.DamageSource;
import org.jetbrains.annotations.Nullable;
import org.skriptlang.skript.bukkit.damagesource.DamageSourceExperimentSyntax;

@Name(value="Damage Source - Food Exhaustion")
@Description(value={"The amount of hunger exhaustion caused by a damage source."})
@Example(value="on damage:\n\tif the food exhaustion of event-damage source is 10:\n")
@Since(value={"2.12"})
@RequiredPlugins(value={"Minecraft 1.20.4+"})
public class ExprFoodExhaustion
extends SimplePropertyExpression<DamageSource, Float>
implements DamageSourceExperimentSyntax {
    @Override
    @Nullable
    public Float convert(DamageSource damageSource) {
        return Float.valueOf(damageSource.getFoodExhaustion());
    }

    @Override
    public Class<Float> getReturnType() {
        return Float.class;
    }

    @Override
    protected String getPropertyName() {
        return "food exhaustion";
    }

    static {
        ExprFoodExhaustion.registerDefault(ExprFoodExhaustion.class, Float.class, "food exhaustion", "damagesources");
    }
}

