/*
 * Decompiled with CFR 0.152.
 */
package org.skriptlang.skript.bukkit.loottables.elements.conditions;

import ch.njol.skript.conditions.base.PropertyCondition;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import org.skriptlang.skript.bukkit.loottables.LootTableUtils;

@Name(value="Has Loot Table")
@Description(value={"Checks whether an entity or block has a loot table. The loot tables of chests will be deleted when the chest is opened or broken."})
@Examples(value={"set event-block to chest", "if event-block has a loot table:", "\t# this will never happen, because it doesn't have a loot table.", "", "set loot table of event-block to \"minecraft:chests/simple_dungeon\"", "", "if event-block has a loot table:", "\t# this will happen, because it now has a loot table."})
@Since(value={"2.10"})
public class CondHasLootTable
extends PropertyCondition<Object> {
    @Override
    public boolean check(Object object) {
        return LootTableUtils.isLootable(object) && LootTableUtils.getLootTable(object) != null;
    }

    @Override
    protected PropertyCondition.PropertyType getPropertyType() {
        return PropertyCondition.PropertyType.HAVE;
    }

    @Override
    protected String getPropertyName() {
        return "a loot table";
    }

    static {
        CondHasLootTable.register(CondHasLootTable.class, PropertyCondition.PropertyType.HAVE, "[a] loot[ ]table", "blocks/entities");
    }
}

