/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.bukkitutil;

import ch.njol.skript.Skript;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import org.bukkit.Registry;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.Nullable;

public class BukkitUtils {
    private static final BiMap<EquipmentSlot, Integer> BUKKIT_EQUIPMENT_SLOT_INDICES = HashBiMap.create();

    public static boolean registryExists(String registry) {
        return Skript.classExists("org.bukkit.Registry") && Skript.fieldExists(Registry.class, registry);
    }

    @Nullable
    public static Registry<PotionEffectType> getPotionEffectTypeRegistry() {
        if (BukkitUtils.registryExists("MOB_EFFECT")) {
            return Registry.MOB_EFFECT;
        }
        if (BukkitUtils.registryExists("EFFECT")) {
            return Registry.EFFECT;
        }
        return null;
    }

    public static Integer getEquipmentSlotIndex(EquipmentSlot equipmentSlot) {
        return (Integer)BUKKIT_EQUIPMENT_SLOT_INDICES.get((Object)equipmentSlot);
    }

    public static EquipmentSlot getEquipmentSlotFromIndex(int slotIndex) {
        return (EquipmentSlot)BUKKIT_EQUIPMENT_SLOT_INDICES.inverse().get((Object)slotIndex);
    }

    static {
        BUKKIT_EQUIPMENT_SLOT_INDICES.put((Object)EquipmentSlot.FEET, (Object)36);
        BUKKIT_EQUIPMENT_SLOT_INDICES.put((Object)EquipmentSlot.LEGS, (Object)37);
        BUKKIT_EQUIPMENT_SLOT_INDICES.put((Object)EquipmentSlot.CHEST, (Object)38);
        BUKKIT_EQUIPMENT_SLOT_INDICES.put((Object)EquipmentSlot.HEAD, (Object)39);
        BUKKIT_EQUIPMENT_SLOT_INDICES.put((Object)EquipmentSlot.OFF_HAND, (Object)40);
    }
}

