/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Events;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerEggThrowEvent;
import org.jetbrains.annotations.Nullable;

@Name(value="Egg Will Hatch")
@Description(value={"Whether the egg will hatch in a Player Egg Throw event."})
@Examples(value={"on player egg throw:", "\tif an entity won't hatch:", "\t\tsend \"Better luck next time!\" to the player"})
@Events(value={"Egg Throw"})
@Since(value={"2.7"})
public class CondWillHatch
extends Condition {
    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (!this.getParser().isCurrentEvent((Class<? extends Event>)PlayerEggThrowEvent.class)) {
            Skript.error("You can't use the 'egg will hatch' condition outside of a Player Egg Throw event.");
            return false;
        }
        this.setNegated(!parseResult.hasTag("will"));
        return true;
    }

    @Override
    public boolean check(Event event) {
        if (!(event instanceof PlayerEggThrowEvent)) {
            return false;
        }
        return ((PlayerEggThrowEvent)event).isHatching() ^ this.isNegated();
    }

    @Override
    public String toString(@Nullable Event event, boolean debug) {
        return "the egg " + (this.isNegated() ? "will" : "will not") + " hatch";
    }

    static {
        Skript.registerCondition(CondWillHatch.class, "[the] egg (:will|will not|won't) hatch");
    }
}

