/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.entity;

import ch.njol.skript.Skript;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.registrations.Classes;
import ch.njol.util.coll.CollectionUtils;
import com.google.common.collect.Iterators;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Objects;
import org.bukkit.entity.Cow;
import org.bukkit.entity.Entity;
import org.jetbrains.annotations.Nullable;

public class CowData
extends EntityData<Cow> {
    private static final boolean VARIANTS_ENABLED;
    private static final Object[] variants;
    private static final Class<Cow> COW_CLASS;
    @Nullable
    private static final Method getVariantMethod;
    @Nullable
    private static final Method setVariantMethod;
    @Nullable
    private Object variant = null;

    public CowData() {
    }

    public CowData(@Nullable Object variant) {
        this.variant = variant;
    }

    @Override
    protected boolean init(Literal<?>[] exprs, int matchedPattern, SkriptParser.ParseResult parseResult) {
        if (VARIANTS_ENABLED) {
            Literal<?> expr = null;
            if (exprs[0] != null) {
                expr = exprs[0];
            } else if (exprs[1] != null) {
                expr = exprs[1];
            }
            if (expr != null) {
                this.variant = expr.getSingle();
            }
        }
        return true;
    }

    @Override
    protected boolean init(@Nullable Class<? extends Cow> entityClass, @Nullable Cow cow) {
        if (cow != null && VARIANTS_ENABLED) {
            this.variant = this.getVariant(cow);
        }
        return true;
    }

    @Override
    public void set(Cow entity) {
        Object finalVariant;
        if (!VARIANTS_ENABLED) {
            return;
        }
        Object object = finalVariant = this.variant != null ? this.variant : CollectionUtils.getRandom(variants);
        assert (finalVariant != null);
        this.setVariant(entity, finalVariant);
    }

    @Override
    protected boolean match(Cow entity) {
        return this.variant == null || this.getVariant(entity) == this.variant;
    }

    @Override
    public Class<Cow> getType() {
        return COW_CLASS;
    }

    @Override
    public EntityData<Cow> getSuperType() {
        return new CowData();
    }

    @Override
    protected int hashCode_i() {
        return Objects.hashCode(this.variant);
    }

    @Override
    protected boolean equals_i(EntityData<?> obj) {
        if (!(obj instanceof CowData)) {
            return false;
        }
        CowData other = (CowData)obj;
        return this.variant == other.variant;
    }

    @Override
    public boolean isSupertypeOf(EntityData<?> entityData) {
        if (!(entityData instanceof CowData)) {
            return false;
        }
        CowData other = (CowData)entityData;
        return this.variant == null || this.variant == other.variant;
    }

    public void setVariant(Cow cow) {
        this.setVariant(cow, this.variant);
    }

    public void setVariant(Cow cow, Object object) {
        if (!VARIANTS_ENABLED || setVariantMethod == null) {
            return;
        }
        Entity entity = (Entity)COW_CLASS.cast(cow);
        try {
            setVariantMethod.invoke((Object)entity, (Cow.Variant)object);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Nullable
    public Object getVariant(Cow cow) {
        if (!VARIANTS_ENABLED || getVariantMethod == null) {
            return null;
        }
        Entity entity = (Entity)COW_CLASS.cast(cow);
        try {
            return getVariantMethod.invoke((Object)entity, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        Class<?> cowClass = null;
        try {
            cowClass = Class.forName("org.bukkit.entity.Cow");
        }
        catch (Exception exception) {
            // empty catch block
        }
        COW_CLASS = cowClass;
        CowData.register(CowData.class, "cow", COW_CLASS, 0, "cow");
        if (Skript.classExists("org.bukkit.entity.Cow$Variant")) {
            VARIANTS_ENABLED = true;
            variants = Iterators.toArray(Classes.getExactClassInfo(Cow.Variant.class).getSupplier().get(), Cow.Variant.class);
            try {
                getVariantMethod = COW_CLASS.getDeclaredMethod("getVariant", new Class[0]);
                setVariantMethod = COW_CLASS.getDeclaredMethod("setVariant", Cow.Variant.class);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not retrieve get/set variant methods for Cow.", e);
            }
        } else {
            VARIANTS_ENABLED = false;
            variants = null;
            getVariantMethod = null;
            setVariantMethod = null;
        }
    }

    public static class CowVariantDummy {
    }
}

