/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.simplification.SimplifiedLiteral;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.util.LiteralUtils;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import java.lang.reflect.Array;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;
import org.skriptlang.skript.lang.comparator.Comparator;
import org.skriptlang.skript.lang.comparator.Comparators;
import org.skriptlang.skript.lang.comparator.Relation;

@Name(value="Sorted List")
@Description(value={"Sorts given list in natural order. All objects in list must be comparable; if they're not, this expression will return nothing."})
@Examples(value={"set {_sorted::*} to sorted {_players::*}"})
@Since(value={"2.2-dev19"})
public class ExprSortedList
extends SimpleExpression<Object> {
    private Expression<?> list;

    public ExprSortedList() {
    }

    public ExprSortedList(Expression<?> list) {
        this.list = list;
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.list = LiteralUtils.defendExpression(exprs[0]);
        return LiteralUtils.canInitSafely(this.list);
    }

    @Override
    @Nullable
    protected Object[] get(Event event) {
        try {
            return this.list.stream(event).sorted(ExprSortedList::compare).toArray();
        }
        catch (ClassCastException | IllegalArgumentException e) {
            return (Object[])Array.newInstance(this.getReturnType(), 0);
        }
    }

    public static <A, B> int compare(A a, B b) throws IllegalArgumentException, ClassCastException {
        if (a instanceof String && b instanceof String) {
            return Relation.get(((String)a).compareToIgnoreCase((String)b)).getRelation();
        }
        Comparator<?, ?> comparator = Comparators.getComparator(a.getClass(), b.getClass());
        if (comparator != null && comparator.supportsOrdering()) {
            return comparator.compare(a, b).getRelation();
        }
        if (!(a instanceof Comparable)) {
            throw new IllegalArgumentException("Cannot compare " + String.valueOf(a.getClass()));
        }
        return ((Comparable)a).compareTo(b);
    }

    @Override
    @Nullable
    public <R> Expression<? extends R> getConvertedExpression(Class<R> ... to) {
        if (CollectionUtils.containsSuperclass(to, this.getReturnType())) {
            return this;
        }
        Expression<R> convertedList = this.list.getConvertedExpression(to);
        if (convertedList != null) {
            return new ExprSortedList(convertedList);
        }
        return null;
    }

    @Override
    public boolean isSingle() {
        return false;
    }

    @Override
    public Class<?> getReturnType() {
        return this.list.getReturnType();
    }

    @Override
    public Class<?>[] possibleReturnTypes() {
        return this.list.possibleReturnTypes();
    }

    @Override
    public boolean canReturn(Class<?> returnType) {
        return this.list.canReturn(returnType);
    }

    @Override
    public Expression<?> simplify() {
        if (this.list instanceof Literal) {
            return SimplifiedLiteral.fromExpression(this);
        }
        return this;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "sorted " + this.list.toString(e, debug);
    }

    static {
        Skript.registerExpression(ExprSortedList.class, Object.class, ExpressionType.PROPERTY, "sorted %objects%");
    }
}

