/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.config.Node;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.common.AnyValued;
import ch.njol.skript.registrations.Feature;
import ch.njol.util.Kleenean;
import java.lang.reflect.Array;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Value")
@Description(value={"Returns the value of something that has a value, e.g. a node in a config.", "The value is automatically converted to the specified type (e.g. text, number) where possible."})
@Examples(value={"set {_node} to node \"language\" in the skript config\nbroadcast the text value of {_node}", "set {_node} to node \"update check interval\" in the skript config\n\nbroadcast text value of {_node}\n# text value of {_node} = \"12 hours\" (text)\n\nwait for {_node}'s timespan value\n# timespan value of {_node} = 12 hours (duration)"})
@Since(value={"2.10 (Nodes), 2.10 (Any)"})
public class ExprValue
extends SimplePropertyExpression<Object, Object> {
    private boolean isSingle;
    private ClassInfo<?> classInfo;
    @Nullable
    private Expression<String> pathExpression;

    @Override
    public boolean init(Expression<?>[] expressions, int pattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        Literal format;
        switch (pattern) {
            case 0: {
                if (!this.getParser().hasExperiment(Feature.SCRIPT_REFLECTION)) {
                    return false;
                }
                this.isSingle = true;
                format = (Literal)expressions[0];
                this.pathExpression = expressions[1];
                this.setExpr(expressions[2]);
                break;
            }
            case 1: {
                this.isSingle = true;
            }
            case 2: {
                format = (Literal)expressions[0];
                this.setExpr(expressions[1]);
                break;
            }
            case 3: {
                this.isSingle = true;
            }
            default: {
                format = (Literal)expressions[1];
                this.setExpr(expressions[0]);
            }
        }
        this.classInfo = (ClassInfo)format.getSingle();
        return true;
    }

    @Override
    @Nullable
    public Object convert(@Nullable Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof AnyValued) {
            AnyValued valued = (AnyValued)object;
            return valued.convertedValue(this.classInfo);
        }
        return null;
    }

    @Override
    protected Object[] get(Event event, Object[] source) {
        if (this.pathExpression != null) {
            Object object = source[0];
            if (!(object instanceof Node)) {
                return (Object[])Array.newInstance(this.getReturnType(), 0);
            }
            Node main = (Node)object;
            String path = this.pathExpression.getSingle(event);
            Node node = main.getNodeAt(path);
            Object[] array = (Object[])Array.newInstance(this.getReturnType(), 1);
            if (!(node instanceof AnyValued)) {
                return (Object[])Array.newInstance(this.getReturnType(), 0);
            }
            AnyValued valued = (AnyValued)((Object)node);
            array[0] = this.convert(valued);
            return array;
        }
        return super.get(source, this);
    }

    @Override
    public Class<?> @Nullable [] acceptChange(Changer.ChangeMode mode) {
        Class[] classArray;
        if (this.pathExpression != null) {
            return null;
        }
        switch (mode) {
            case SET: {
                Class[] classArray2 = new Class[1];
                classArray = classArray2;
                classArray2[0] = Object.class;
                break;
            }
            case RESET: 
            case DELETE: {
                classArray = new Class[]{};
                break;
            }
            default: {
                classArray = null;
            }
        }
        return classArray;
    }

    @Override
    public void change(Event event, Object @Nullable [] delta, Changer.ChangeMode mode) {
        if (this.pathExpression != null) {
            return;
        }
        Object newValue = delta != null ? delta[0] : null;
        for (Object object : this.getExpr().getArray(event)) {
            AnyValued valued;
            if (!(object instanceof AnyValued) || !(valued = (AnyValued)object).supportsValueChange()) continue;
            valued.changeValueSafely(newValue);
        }
    }

    @Override
    public Class<?> getReturnType() {
        return this.classInfo.getC();
    }

    @Override
    public boolean isSingle() {
        return this.isSingle;
    }

    @Override
    protected String getPropertyName() {
        return this.classInfo.getCodeName() + " value" + (this.isSingle ? "" : "s");
    }

    @Override
    public String toString(@Nullable Event event, boolean debug) {
        if (this.pathExpression != null) {
            return "the " + this.getPropertyName() + " at " + this.pathExpression.toString(event, debug) + " in " + this.getExpr().toString(event, debug);
        }
        return super.toString(event, debug);
    }

    static {
        Skript.registerExpression(ExprValue.class, Object.class, ExpressionType.PROPERTY, "[the] %*classinfo% value [at] %string% (from|in) %node%", "[the] %*classinfo% value of %valued%", "[the] %*classinfo% values of %valueds%", "%valued%'s %*classinfo% value", "%valueds%'[s] %*classinfo% values");
    }
}

