/*
 * Decompiled with CFR 0.152.
 */
package org.skriptlang.skript.log.runtime;

import ch.njol.skript.log.SkriptLogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.jetbrains.annotations.UnmodifiableView;
import org.skriptlang.skript.log.runtime.Frame;
import org.skriptlang.skript.log.runtime.RuntimeError;
import org.skriptlang.skript.log.runtime.RuntimeErrorConsumer;
import org.skriptlang.skript.log.runtime.RuntimeErrorManager;

public class RuntimeErrorCatcher
implements RuntimeErrorConsumer {
    private List<RuntimeErrorConsumer> storedConsumers = new ArrayList<RuntimeErrorConsumer>();
    private final List<RuntimeError> cachedErrors = new ArrayList<RuntimeError>();
    private final List<Map.Entry<Frame.FrameOutput, Level>> cachedFrames = new ArrayList<Map.Entry<Frame.FrameOutput, Level>>();

    private RuntimeErrorManager getManager() {
        return RuntimeErrorManager.getInstance();
    }

    public RuntimeErrorCatcher start() {
        this.storedConsumers = this.getManager().removeAllConsumers();
        this.getManager().addConsumer(this);
        return this;
    }

    public void stop() {
        if (!this.getManager().removeConsumer(this)) {
            SkriptLogger.LOGGER.severe("[Skript] A 'RuntimeErrorCatcher' was stopped incorrectly.");
            return;
        }
        this.getManager().addConsumers((RuntimeErrorConsumer[])this.storedConsumers.toArray(RuntimeErrorConsumer[]::new));
        for (RuntimeError runtimeError : this.cachedErrors) {
            this.storedConsumers.forEach(consumer -> consumer.printError(runtimeError));
        }
        for (Map.Entry entry : this.cachedFrames) {
            this.storedConsumers.forEach(consumer -> consumer.printFrameOutput((Frame.FrameOutput)entry.getKey(), (Level)entry.getValue()));
        }
    }

    public @UnmodifiableView List<RuntimeError> getCachedErrors() {
        return Collections.unmodifiableList(this.cachedErrors);
    }

    public @UnmodifiableView List<Map.Entry<Frame.FrameOutput, Level>> getCachedFrames() {
        return Collections.unmodifiableList(this.cachedFrames);
    }

    public RuntimeErrorCatcher clearCachedErrors() {
        this.cachedErrors.clear();
        return this;
    }

    public RuntimeErrorCatcher clearCachedFrames() {
        this.cachedFrames.clear();
        return this;
    }

    @Override
    public void printError(RuntimeError error) {
        this.cachedErrors.add(error);
    }

    @Override
    public void printFrameOutput(final Frame.FrameOutput output, final Level level) {
        this.cachedFrames.add(new Map.Entry<Frame.FrameOutput, Level>(){

            @Override
            public Frame.FrameOutput getKey() {
                return output;
            }

            @Override
            public Level getValue() {
                return level;
            }

            @Override
            public Level setValue(Level value) {
                return null;
            }
        });
    }
}

