/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.entity;

import ch.njol.skript.Skript;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import java.util.Random;
import org.bukkit.entity.Bee;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BeeData
extends EntityData<Bee> {
    private int nectar = 0;
    private int angry = 0;

    @Override
    protected boolean init(Literal<?>[] exprs, int matchedPattern, SkriptParser.ParseResult parseResult) {
        if (matchedPattern > 3) {
            this.angry = 1;
        } else if (matchedPattern < 2) {
            this.angry = -1;
        }
        if (matchedPattern == 3 || matchedPattern == 5) {
            this.nectar = 1;
        } else if (matchedPattern < 2) {
            this.nectar = -1;
        }
        return true;
    }

    @Override
    protected boolean init(@Nullable Class<? extends Bee> c, @Nullable Bee e) {
        int n = e == null ? 0 : (this.angry = e.getAnger() > 0 ? 1 : -1);
        this.nectar = e == null ? 0 : (e.hasNectar() ? 1 : -1);
        return true;
    }

    @Override
    public void set(Bee entity) {
        int random = new Random().nextInt(400) + 400;
        entity.setAnger(this.angry > 0 ? random : 0);
        entity.setHasNectar(this.nectar > 0);
    }

    @Override
    protected boolean match(Bee entity) {
        return !(this.angry != 0 && entity.getAnger() > 0 != (this.angry == 1) || this.nectar != 0 && entity.hasNectar() != (this.nectar == 1));
    }

    @Override
    public Class<? extends Bee> getType() {
        return Bee.class;
    }

    @Override
    protected int hashCode_i() {
        int prime = 31;
        int result = 1;
        result = prime * result + this.angry;
        result = prime * result + this.nectar;
        return result;
    }

    @Override
    protected boolean equals_i(EntityData<?> obj) {
        if (!(obj instanceof BeeData)) {
            return false;
        }
        BeeData other = (BeeData)obj;
        return this.angry == other.angry && this.nectar == other.nectar;
    }

    @Override
    public boolean isSupertypeOf(EntityData<?> e) {
        return !(!(e instanceof BeeData) || this.angry != 0 && ((BeeData)e).angry != this.angry || this.nectar != 0 && ((BeeData)e).nectar != this.nectar);
    }

    @Override
    @NotNull
    public EntityData getSuperType() {
        return new BeeData();
    }

    static {
        if (Skript.classExists("org.bukkit.entity.Bee")) {
            EntityData.register(BeeData.class, "bee", Bee.class, 2, "no nectar bee", "happy bee", "bee", "nectar bee", "angry bee", "angry nectar bee");
        }
    }
}

