/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.entity;

import ch.njol.skript.Skript;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import org.bukkit.entity.Fox;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FoxData
extends EntityData<Fox> {
    @Nullable
    private Fox.Type type = null;

    public FoxData() {
    }

    public FoxData(@Nullable Fox.Type type) {
        this.type = type;
        this.matchedPattern = type == Fox.Type.SNOW ? 2 : 1;
    }

    @Override
    protected boolean init(Literal<?>[] exprs, int matchedPattern, SkriptParser.ParseResult parseResult) {
        if (matchedPattern > 0) {
            this.type = Fox.Type.values()[matchedPattern - 1];
        }
        return true;
    }

    @Override
    protected boolean init(@Nullable Class<? extends Fox> c, @Nullable Fox fox) {
        if (fox != null) {
            this.type = fox.getFoxType();
        }
        return true;
    }

    @Override
    public void set(Fox entity) {
        if (this.type != null) {
            entity.setFoxType(this.type);
        }
    }

    @Override
    protected boolean match(Fox entity) {
        return this.type == null || this.type == entity.getFoxType();
    }

    @Override
    public Class<? extends Fox> getType() {
        return Fox.class;
    }

    @Override
    @NotNull
    public EntityData getSuperType() {
        return new FoxData(this.type);
    }

    @Override
    protected int hashCode_i() {
        return this.type != null ? this.type.hashCode() : 0;
    }

    @Override
    protected boolean equals_i(EntityData<?> data) {
        if (!(data instanceof FoxData)) {
            return false;
        }
        return this.type == ((FoxData)data).type;
    }

    @Override
    public boolean isSupertypeOf(EntityData<?> data) {
        if (!(data instanceof FoxData)) {
            return false;
        }
        return this.type == null || this.type == ((FoxData)data).type;
    }

    static {
        if (Skript.classExists("org.bukkit.entity.Fox")) {
            EntityData.register(FoxData.class, "fox", Fox.class, 1, "fox", "red fox", "snow fox");
        }
    }
}

