/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Events;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.EventRestrictedSyntax;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerKickEvent;
import org.jetbrains.annotations.Nullable;

@Name(value="On-screen Kick Message")
@Description(value={"The kick message that is displayed on-screen when a player is kicked."})
@Examples(value={"on kick:", "\ton-screen kick message is \"Invalid hotbar selection (Hacking?)\"", "\tcancel event"})
@Since(value={"2.12"})
@Events(value={"Kick"})
public class ExprOnScreenKickMessage
extends SimpleExpression<String>
implements EventRestrictedSyntax {
    @Override
    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        return true;
    }

    protected String @Nullable [] get(Event event) {
        if (event instanceof PlayerKickEvent) {
            PlayerKickEvent playerKickEvent = (PlayerKickEvent)event;
            return new String[]{playerKickEvent.getReason()};
        }
        return null;
    }

    @Override
    public Class<?> @Nullable [] acceptChange(Changer.ChangeMode mode) {
        return mode == Changer.ChangeMode.SET ? CollectionUtils.array(String.class) : null;
    }

    @Override
    public void change(Event event, Object @Nullable [] delta, Changer.ChangeMode mode) {
        assert (delta != null);
        assert (delta.length == 1);
        if (event instanceof PlayerKickEvent) {
            PlayerKickEvent kickEvent = (PlayerKickEvent)event;
            Object object = delta[0];
            if (object instanceof String) {
                String text = (String)object;
                kickEvent.setReason(text);
            }
        }
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    @Override
    public Class<? extends String> getReturnType() {
        return String.class;
    }

    @Override
    public String toString(@Nullable Event event, boolean debug) {
        return "the on-screen kick message";
    }

    @Override
    public Class<? extends Event>[] supportedEvents() {
        return CollectionUtils.array(PlayerKickEvent.class);
    }

    static {
        Skript.registerExpression(ExprOnScreenKickMessage.class, String.class, ExpressionType.SIMPLE, "[the] on-screen kick message");
    }
}

