/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.bukkitutil.PaperEntityUtils;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import io.papermc.paper.entity.LookAnchor;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Look At")
@Description(value={"Forces the mob(s) or player(s) to look at an entity, vector or location. Vanilla max head pitches range from 10 to 50."})
@Examples(value={"force the player to look towards event-entity's feet", "", "on entity explosion:", "\tset {_player} to the nearest player", "\t{_player} is set", "\tdistance between {_player} and the event-location is less than 15", "\tmake {_player} look towards vector from the {_player} to location of the event-entity", "", "force {_enderman} to face the block 3 meters above {_location} at head rotation speed 100.5 and max head pitch -40"})
@Since(value={"2.7"})
public class EffLook
extends Effect {
    private static final boolean LOOK_ANCHORS = Skript.classExists("io.papermc.paper.entity.LookAnchor");
    private LookAnchor anchor = LookAnchor.EYES;
    private Expression<LivingEntity> entities;
    @Nullable
    private Expression<Number> speed;
    @Nullable
    private Expression<Number> maxPitch;
    private Expression<?> target;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.entities = exprs[0];
        if (LOOK_ANCHORS && matchedPattern == 0) {
            this.target = exprs[parseResult.hasTag("of") ? 2 : 1];
            this.speed = exprs[3];
            this.maxPitch = exprs[4];
            if (parseResult.hasTag("feet")) {
                this.anchor = LookAnchor.FEET;
            }
        } else {
            this.target = exprs[1];
            this.speed = exprs[2];
            this.maxPitch = exprs[3];
        }
        return true;
    }

    @Override
    protected void execute(Event event) {
        Float maxPitch;
        Object object = this.target.getSingle(event);
        if (object == null) {
            return;
        }
        Float speed = this.speed == null ? null : (Float)this.speed.getOptionalSingle(event).map(Number::floatValue).orElse(null);
        Float f = maxPitch = this.maxPitch == null ? null : (Float)this.maxPitch.getOptionalSingle(event).map(Number::floatValue).orElse(null);
        if (LOOK_ANCHORS) {
            PaperEntityUtils.lookAt(this.anchor, object, speed, maxPitch, this.entities.getArray(event));
        } else {
            PaperEntityUtils.lookAt(object, speed, maxPitch, this.entities.getArray(event));
        }
    }

    @Override
    public String toString(@Nullable Event event, boolean debug) {
        return "force " + this.entities.toString(event, debug) + " to look at " + this.target.toString(event, debug);
    }

    static {
        if (Skript.methodExists(Mob.class, "lookAt", Entity.class)) {
            if (LOOK_ANCHORS) {
                Skript.registerEffect(EffLook.class, "(force|make) %livingentities% [to] (face [towards]|look [(at|towards)]) (%entity%['s (feet:feet|eyes)]|of:(feet:feet|eyes) of %entity%) [at [head] [rotation] speed %-number%] [[and] max[imum] [head] pitch %-number%]", "(force|make) %livingentities% [to] (face [towards]|look [(at|towards)]) %vector/location% [at [head] [rotation] speed %-number%] [[and] max[imum] [head] pitch %-number%]");
            } else {
                Skript.registerEffect(EffLook.class, "(force|make) %livingentities% [to] (face [towards]|look [(at|towards)]) %vector/location/entity% [at [head] [rotation] speed %-number%] [[and] max[imum] [head] pitch %-number%]");
            }
        }
    }
}

