/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.hooks.regions.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.hooks.regions.RegionsPlugin;
import ch.njol.skript.hooks.regions.classes.Region;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.util.Direction;
import ch.njol.util.Kleenean;
import java.util.ArrayList;
import org.bukkit.Location;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Regions At")
@Description(value={"All <a href='#region'>regions</a> at a particular <a href='./classes/#location'>location</a>.", "This expression requires a supported regions plugin to be installed."})
@Examples(value={"On click on a sign:", "\tline 1 of the clicked block is \"[region info]\"", "\tset {_regions::*} to regions at the clicked block", "\tif {_regions::*} is empty:", "\t\tmessage \"No regions exist at this sign.\"", "\telse:", "\t\tmessage \"Regions containing this sign: &lt;gold&gt;%{_regions::*}%<r>.\""})
@Since(value={"2.1"})
@RequiredPlugins(value={"Supported regions plugin"})
public class ExprRegionsAt
extends SimpleExpression<Region> {
    private Expression<Location> locs;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (matchedPattern == 1) {
            Skript.warning("Most regions plugins can have multiple intersecting regions at a the same location, thus it is recommended to use \"regions at ...\" instead of \"region at...\" for clarity.");
        }
        this.locs = Direction.combine(exprs[0], exprs[1]);
        return true;
    }

    @Nullable
    protected Region[] get(Event e) {
        Location[] ls = this.locs.getArray(e);
        if (ls.length == 0) {
            return new Region[0];
        }
        ArrayList<Region> r = new ArrayList<Region>();
        for (Location l : ls) {
            r.addAll(RegionsPlugin.getRegionsAt(l));
        }
        return r.toArray(new Region[r.size()]);
    }

    @Override
    public boolean isSingle() {
        return false;
    }

    @Override
    public Class<? extends Region> getReturnType() {
        return Region.class;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "the regions at " + this.locs.toString(e, debug);
    }

    static {
        Skript.registerExpression(ExprRegionsAt.class, Region.class, ExpressionType.PROPERTY, "[the] region(1\u00a6s|) %direction% %locations%");
    }
}

