/*
 * Decompiled with CFR 0.152.
 */
package org.skriptlang.skript.lang.properties;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.expressions.ExprSubnodeValue;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.lang.parser.ParserInstance;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.StringMode;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.skriptlang.skript.lang.converter.Converters;

@ApiStatus.Experimental
public interface PropertyHandler<Type> {
    default public PropertyHandler<Type> newInstance() {
        return this;
    }

    default public boolean init(Expression<?> parentExpression, ParserInstance parser) {
        return true;
    }

    @ApiStatus.Experimental
    public static interface ContainsHandler<Container, Element>
    extends PropertyHandler<Container> {
        public boolean contains(Container var1, Element var2);

        public Class<? extends Element>[] elementTypes();

        default public boolean canContain(Class<?> type) {
            for (Class<Element> elementType : this.elementTypes()) {
                if (!elementType.isAssignableFrom(type)) continue;
                return true;
            }
            return false;
        }
    }

    @ApiStatus.Experimental
    public static interface ConditionPropertyHandler<Type>
    extends PropertyHandler<Type> {
        public boolean check(Type var1);

        @Contract(value="_ -> new", pure=true)
        @NotNull
        public static <Type> ConditionPropertyHandler<Type> of(Predicate<Type> predicate) {
            return predicate::test;
        }
    }

    @ApiStatus.Experimental
    public static interface TypedValuePropertyHandler<Type, ValueType>
    extends ExpressionPropertyHandler<Type, ValueType> {
        @Override
        @Nullable
        public ValueType convert(Type var1);

        default public <Converted> Converted convert(Type propertyHolder, ClassInfo<Converted> expected) {
            ValueType value = this.convert(propertyHolder);
            if (value == null) {
                return null;
            }
            return ExprSubnodeValue.convertedValue(value, expected);
        }

        default public ValueType convertChangeValue(Object value) throws UnsupportedOperationException {
            Class typeClass = this.returnType();
            ClassInfo classInfo = Classes.getSuperClassInfo(typeClass);
            if (value == null) {
                return null;
            }
            if (typeClass == String.class) {
                return (ValueType)typeClass.cast(Classes.toString(value, StringMode.MESSAGE));
            }
            if (value instanceof String) {
                String string = (String)value;
                if (classInfo.getParser() != null && classInfo.getParser().canParse(ParseContext.CONFIG)) {
                    return (ValueType)classInfo.getParser().parse(string, ParseContext.CONFIG);
                }
            }
            return (ValueType)Converters.convert(value, typeClass);
        }
    }

    @ApiStatus.Experimental
    public static interface ExpressionPropertyHandler<Type, ReturnType>
    extends PropertyHandler<Type> {
        @Nullable
        public ReturnType convert(Type var1);

        default public Class<?> @Nullable [] acceptChange(Changer.ChangeMode mode) {
            return null;
        }

        default public void change(Type propertyHolder, Object @Nullable [] delta, Changer.ChangeMode mode) {
            throw new UnsupportedOperationException("Changing is not supported for this property.");
        }

        default public boolean requiresSourceExprChange() {
            return false;
        }

        @NotNull
        public Class<ReturnType> returnType();

        default public Class<?> @NotNull [] possibleReturnTypes() {
            return new Class[]{this.returnType()};
        }

        @Contract(value="_, _ -> new", pure=true)
        @NotNull
        public static <Type, ReturnType> ExpressionPropertyHandler<Type, ReturnType> of(final Function<Type, ReturnType> converter, final @NotNull Class<ReturnType> returnType) {
            return new ExpressionPropertyHandler<Type, ReturnType>(){

                @Override
                @Nullable
                public ReturnType convert(Type propertyHolder) {
                    return converter.apply(propertyHolder);
                }

                @Override
                @NotNull
                public Class<ReturnType> returnType() {
                    return returnType;
                }
            };
        }
    }
}

