package ch.njol.skript.effects;

import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser.ParseResult;
import ch.njol.util.Kleenean;

@Name("Make Invulnerable")
@Description("Makes an entity invulnerable/not invulnerable.")
@Examples("make target entity invulnerable")
@Since("2.5")
public class EffInvulnerability extends Effect {
	
	static {
		Skript.registerEffect(EffInvulnerability.class,
			"make %entities% (invulnerable|invincible)",
			"make %entities% (not (invulnerable|invincible)|vulnerable|vincible)");
	}
	
	@SuppressWarnings("null")
	private Expression<Entity> entities;
	private boolean invulnerable;
	
	@SuppressWarnings({"unchecked", "null"})
	@Override
	public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, ParseResult parseResult) {
		entities = (Expression<Entity>) exprs[0];
		invulnerable = matchedPattern == 0;
		return true;
	}
	
	@Override
	protected void execute(Event event) {
		for (Entity entity : entities.getArray(event)) {
			entity.setInvulnerable(invulnerable);
		}
	}
	
	@Override
	public String toString(@Nullable Event event, boolean debug) {
		return "make " + entities.toString(event, debug) + (invulnerable ? " invulnerable" : " not invulnerable");
	}
	
}
