/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.conditions.base.PropertyCondition;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Example;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.Nullable;

@Name(value="Has Potion")
@Description(value={"Checks whether the given living entities have potion effects."})
@Example(value="if player has potion speed:\n\tsend \"You are sonic!\"\n\tif all players have potion effects speed and haste:\n\t\tbroadcast \"You are ready to MINE!\"\n")
@Since(value={"2.6.1"})
public class CondHasPotion
extends Condition {
    private Expression<PotionEffectType> potionEffects;
    private Expression<LivingEntity> livingEntities;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.livingEntities = exprs[0];
        this.potionEffects = exprs[1];
        this.setNegated(matchedPattern == 1);
        return true;
    }

    @Override
    public boolean check(Event event) {
        if (this.potionEffects == null) {
            return this.livingEntities.check(event, entity -> !entity.getActivePotionEffects().isEmpty(), this.isNegated());
        }
        return this.livingEntities.check(event, entity -> this.potionEffects.check(event, arg_0 -> ((LivingEntity)entity).hasPotionEffect(arg_0)), this.isNegated());
    }

    @Override
    public String toString(@Nullable Event event, boolean debug) {
        String effects = this.potionEffects == null ? "any potion effect" : "potion " + this.potionEffects.toString(event, debug);
        return PropertyCondition.toString(this, PropertyCondition.PropertyType.HAVE, event, debug, this.livingEntities, effects);
    }

    static {
        Skript.registerCondition(CondHasPotion.class, PropertyCondition.getPatterns(PropertyCondition.PropertyType.HAVE, "([any] potion effect[s]|potion[s] [effect[s]] %-potioneffecttypes%)", "livingentities"));
    }
}

