/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Direction;
import ch.njol.skript.util.visual.VisualEffect;
import ch.njol.util.Kleenean;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Play Effect")
@Description(value={"Plays a <a href='#visualeffect'>visual effect</a> at a given location or on a given entity.", "Please note that some effects can only be played on entities, e.g. wolf hearts or the hurt effect, and that these are always visible to all players."})
@Examples(value={"play wolf hearts on the clicked wolf", "show mob spawner flames at the targeted block to the player"})
@Since(value={"2.1"})
public class EffVisualEffect
extends Effect {
    private Expression<VisualEffect> effects;
    private Expression<Direction> direction;
    private Expression<?> where;
    @Nullable
    private Expression<Player> players;
    @Nullable
    private Expression<Number> radius;
    @Nullable
    private Expression<Number> count;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        int base = 0;
        if (matchedPattern == 1) {
            this.count = exprs[0];
            base = 1;
        }
        this.effects = exprs[base];
        this.direction = exprs[base + 1];
        this.where = exprs[base + 2];
        this.players = exprs[base + 3];
        this.radius = exprs[base + 4];
        if (this.effects instanceof Literal) {
            VisualEffect[] effs = this.effects.getArray(null);
            boolean hasLocationEffect = false;
            boolean hasEntityEffect = false;
            for (VisualEffect e : effs) {
                if (e.getType().isEntityEffect()) {
                    hasEntityEffect = true;
                    continue;
                }
                hasLocationEffect = true;
            }
            if (!hasLocationEffect && this.players != null) {
                Skript.warning("Entity effects are visible to all players");
            }
            if (!hasLocationEffect && !this.direction.isDefault()) {
                Skript.warning("Entity effects are always played on an entity");
            }
            if (hasEntityEffect && !this.where.canReturn(Entity.class)) {
                Skript.error("Entity effects can only be played on entities");
                return false;
            }
        }
        return true;
    }

    @Override
    protected void execute(Event e) {
        Integer cnt;
        VisualEffect[] effects = this.effects.getArray(e);
        Direction[] directions = this.direction.getArray(e);
        ?[] os = this.where.getArray(e);
        Player[] ps = this.players != null ? this.players.getArray(e) : null;
        Integer rad = this.radius != null ? (Number)this.radius.getSingle(e) : (Number)32;
        Number number = cnt = this.count != null ? (Number)this.count.getSingle(e) : (Number)0;
        if (effects == null || directions == null || os == null || rad == null || cnt == null) {
            return;
        }
        for (Direction d : directions) {
            for (Object o : os) {
                if (o instanceof Entity) {
                    for (VisualEffect eff : effects) {
                        eff.play(ps, d.getRelative((Entity)o), (Entity)o, cnt, rad);
                    }
                    continue;
                }
                if (o instanceof Location) {
                    for (VisualEffect eff : effects) {
                        if (eff.getType().isEntityEffect()) continue;
                        eff.play(ps, d.getRelative((Location)o), null, cnt, rad);
                    }
                    continue;
                }
                assert (false);
            }
        }
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "play " + this.effects.toString(e, debug) + " " + this.direction.toString(e, debug) + " " + this.where.toString(e, debug) + (String)(this.players != null ? " to " + this.players.toString(e, debug) : "");
    }

    static {
        Skript.registerEffect(EffVisualEffect.class, "(play|show) %visualeffects% (on|%directions%) %entities/locations% [(to %-players%|in (radius|range) of %-number%)]", "(play|show) %number% %visualeffects% (on|%directions%) %entities/locations% [(to %-players%|in (radius|range) of %-number%)]");
    }
}

