/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.simplification.SimplifiedLiteral;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.Location;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.Nullable;

@Name(value="Vectors - Location Vector Offset")
@Description(value={"Returns the location offset by vectors."})
@Examples(value={"set {_loc} to {_loc} ~ {_v}"})
@Since(value={"2.2-dev28"})
public class ExprLocationVectorOffset
extends SimpleExpression<Location> {
    private Expression<Location> location;
    private Expression<Vector> vectors;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.location = exprs[0];
        this.vectors = exprs[1];
        return true;
    }

    protected Location[] get(Event e) {
        Location l = this.location.getSingle(e);
        if (l == null) {
            return null;
        }
        Location clone = l.clone();
        for (Vector v : this.vectors.getArray(e)) {
            clone.add(v);
        }
        return CollectionUtils.array(clone);
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    @Override
    public Class<? extends Location> getReturnType() {
        return Location.class;
    }

    @Override
    public Expression<? extends Location> simplify() {
        if (this.location instanceof Literal && this.vectors instanceof Literal) {
            return SimplifiedLiteral.fromExpression(this);
        }
        return this;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return this.location.toString() + " offset by " + this.vectors.toString();
    }

    static {
        Skript.registerExpression(ExprLocationVectorOffset.class, Location.class, ExpressionType.PROPERTY, "%location% offset by [[the] vectors] %vectors%", "%location%[ ]~[~][ ]%vectors%");
    }
}

