/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.util.Timespan;
import ch.njol.util.Kleenean;
import org.bukkit.event.Event;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.Nullable;

@Name(value="Potion Effect")
@Description(value={"Create a new potion effect to apply to an entity or item type. Do note that when applying potion effects ", "to tipped arrows/lingering potions, Minecraft reduces the timespan."})
@Examples(value={"set {_p} to potion effect of speed of tier 1 without particles for 10 minutes", "add {_p} to potion effects of player's tool", "add {_p} to potion effects of target entity", "add potion effect of speed 1 to potion effects of player"})
@Since(value={"2.5.2"})
public class ExprPotionEffect
extends SimpleExpression<PotionEffect> {
    private Expression<PotionEffectType> potionEffectType;
    @Nullable
    private Expression<Number> tier;
    @Nullable
    private Expression<Timespan> timespan;
    private boolean particles;
    private boolean ambient;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.potionEffectType = exprs[0];
        this.tier = exprs[1];
        this.timespan = exprs[2];
        this.particles = parseResult.mark == 0;
        this.ambient = matchedPattern == 1;
        return true;
    }

    @Nullable
    protected PotionEffect[] get(Event e) {
        Timespan timespan;
        Number n;
        PotionEffectType potionEffectType = this.potionEffectType.getSingle(e);
        if (potionEffectType == null) {
            return null;
        }
        int tier = 0;
        if (this.tier != null && (n = this.tier.getSingle(e)) != null) {
            tier = n.intValue() - 1;
        }
        int ticks = 300;
        if (this.timespan != null && (timespan = this.timespan.getSingle(e)) != null) {
            ticks = timespan.isInfinite() ? -1 : (int)timespan.getAs(Timespan.TimePeriod.TICK);
        }
        return new PotionEffect[]{new PotionEffect(potionEffectType, ticks, tier, this.ambient, this.particles)};
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    @Override
    public Class<? extends PotionEffect> getReturnType() {
        return PotionEffect.class;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        StringBuilder builder = new StringBuilder();
        if (this.ambient) {
            builder.append("ambient ");
        }
        builder.append("potion of ").append(this.potionEffectType.toString(e, debug));
        if (this.tier != null) {
            String t = this.tier.toString(e, debug);
            builder.append(" of tier/amp ").append(t);
        }
        if (!this.particles) {
            builder.append(" without particles");
        }
        builder.append(" for ");
        if (this.timespan != null) {
            builder.append(this.timespan.toString(e, debug));
        } else {
            builder.append("15 seconds");
        }
        return builder.toString();
    }

    static {
        Skript.registerExpression(ExprPotionEffect.class, PotionEffect.class, ExpressionType.COMBINED, "[a] [new] potion effect of %potioneffecttype% [potion] [[[of] tier] %-number%] [(1\u00a6without particles)] [for %-timespan%]", "[a] [new] ambient potion effect of %potioneffecttype% [potion] [[[of] tier] %-number%] [(1\u00a6without particles)] [for %-timespan%]");
    }
}

