/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.ExprColoured;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionList;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.VariableString;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.util.SkriptColor;
import ch.njol.util.Kleenean;
import ch.njol.util.StringUtils;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Raw String")
@Description(value={"Returns the string without formatting (colors etc.) and without stripping them from it, e.g. <code>raw \"&aHello There!\"</code> would output <code>&aHello There!</code>"})
@Examples(value={"send raw \"&aThis text is unformatted!\" to all players"})
@Since(value={"2.7"})
public class ExprRawString
extends SimpleExpression<String> {
    private static final Pattern HEX_PATTERN = Pattern.compile("(?i)&x((?:&\\p{XDigit}){6})");
    private Expression<String> expr;
    private Expression<? extends String>[] messages;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        Expression[] expressionArray;
        this.expr = exprs[0];
        if (this.expr instanceof ExpressionList) {
            expressionArray = ((ExpressionList)this.expr).getExpressions();
        } else {
            Expression[] expressionArray2 = new Expression[1];
            expressionArray = expressionArray2;
            expressionArray2[0] = this.expr;
        }
        for (Expression<? extends String> message : this.messages = expressionArray) {
            if (!(message instanceof ExprColoured)) continue;
            Skript.error("The 'colored' expression may not be used in a 'raw string' expression");
            return false;
        }
        return true;
    }

    protected String[] get(Event event) {
        ArrayList<String> strings = new ArrayList<String>();
        for (Expression<? extends String> message : this.messages) {
            if (message instanceof VariableString) {
                strings.add(((VariableString)message).toUnformattedString(event));
                continue;
            }
            for (String string : message.getArray(event)) {
                String raw = SkriptColor.replaceColorChar(string);
                if (raw.toLowerCase().contains("&x")) {
                    raw = StringUtils.replaceAll((CharSequence)raw, HEX_PATTERN, matchResult -> "<#" + matchResult.group(1).replace("&", "") + ">");
                }
                strings.add(raw);
            }
        }
        return strings.toArray(new String[0]);
    }

    @Override
    public boolean isSingle() {
        return this.expr.isSingle();
    }

    @Override
    public Class<? extends String> getReturnType() {
        return String.class;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "raw " + this.expr.toString(e, debug);
    }

    static {
        Skript.registerExpression(ExprRawString.class, String.class, ExpressionType.COMBINED, "raw %strings%");
    }
}

