/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.lang;

import ch.njol.skript.SkriptAPIException;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionInfo;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptEventInfo;
import ch.njol.skript.lang.SyntaxElement;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Unmodifiable;
import org.skriptlang.skript.bukkit.registration.BukkitSyntaxInfos;
import org.skriptlang.skript.lang.structure.StructureInfo;
import org.skriptlang.skript.registration.DefaultSyntaxInfos;
import org.skriptlang.skript.registration.SyntaxInfo;
import org.skriptlang.skript.registration.SyntaxOrigin;
import org.skriptlang.skript.util.Priority;

public class SyntaxElementInfo<E extends SyntaxElement>
implements SyntaxInfo<E> {
    public final Class<E> elementClass;
    public final String[] patterns;
    public final String originClassPath;

    public SyntaxElementInfo(String[] patterns, Class<E> elementClass, String originClassPath) throws IllegalArgumentException {
        if (Modifier.isAbstract(elementClass.getModifiers())) {
            throw new SkriptAPIException("Class " + elementClass.getName() + " is abstract");
        }
        this.patterns = patterns;
        this.elementClass = elementClass;
        this.originClassPath = originClassPath;
        try {
            elementClass.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new Error(String.valueOf(elementClass) + " does not have a public nullary constructor", e);
        }
        catch (SecurityException e) {
            throw new IllegalStateException("Skript cannot run properly because a security manager is blocking it!");
        }
    }

    public Class<E> getElementClass() {
        return this.elementClass;
    }

    public String[] getPatterns() {
        return Arrays.copyOf(this.patterns, this.patterns.length);
    }

    public String getOriginClassPath() {
        return this.originClassPath;
    }

    @Contract(value="_ -> new")
    @ApiStatus.Internal
    @ApiStatus.Experimental
    public static <I extends SyntaxElementInfo<E>, E extends SyntaxElement> I fromModern(SyntaxInfo<? extends E> info) {
        if (info instanceof SyntaxElementInfo) {
            SyntaxElementInfo oldInfo = (SyntaxElementInfo)info;
            return (I)oldInfo;
        }
        if (info instanceof BukkitSyntaxInfos.Event) {
            BukkitSyntaxInfos.Event event = (BukkitSyntaxInfos.Event)info;
            Object rawName = event.name().startsWith("On ") ? event.name().substring(3) : "*" + event.name();
            SkriptEventInfo eventInfo = new SkriptEventInfo((String)rawName, event.patterns().toArray(new String[0]), event.type(), event.origin().name(), event.events().toArray(new Class[0]));
            String documentationId = event.documentationId();
            if (documentationId != null) {
                eventInfo.documentationID(documentationId);
            }
            eventInfo.listeningBehavior(event.listeningBehavior()).since(event.since().toArray(new String[0])).description(event.description().toArray(new String[0])).examples(event.examples().toArray(new String[0])).keywords(event.keywords().toArray(new String[0])).requiredPlugins(event.requiredPlugins().toArray(new String[0]));
            return (I)eventInfo;
        }
        if (info instanceof DefaultSyntaxInfos.Structure) {
            DefaultSyntaxInfos.Structure structure = (DefaultSyntaxInfos.Structure)info;
            return (I)new StructureInfo(structure.patterns().toArray(new String[0]), structure.type(), structure.origin().name(), structure.entryValidator(), structure.nodeType());
        }
        if (info instanceof DefaultSyntaxInfos.Expression) {
            DefaultSyntaxInfos.Expression expression = (DefaultSyntaxInfos.Expression)info;
            return (I)SyntaxElementInfo.fromModernExpression(expression);
        }
        return (I)new SyntaxElementInfo<E>(info.patterns().toArray(new String[0]), info.type(), info.origin().name());
    }

    @Contract(value="_ -> new")
    @ApiStatus.Experimental
    private static <E extends Expression<R>, R> ExpressionInfo<E, R> fromModernExpression(DefaultSyntaxInfos.Expression<E, R> info) {
        return new ExpressionInfo(info.patterns().toArray(new String[0]), info.returnType(), info.type(), info.origin().name(), ExpressionType.fromModern(info.priority()));
    }

    @Override
    @ApiStatus.Internal
    public SyntaxInfo.Builder<? extends SyntaxInfo.Builder<?, E>, E> toBuilder() {
        throw new UnsupportedOperationException();
    }

    @Override
    @ApiStatus.Internal
    public SyntaxOrigin origin() {
        return () -> this.originClassPath;
    }

    @Override
    @ApiStatus.Internal
    public Class<E> type() {
        return this.getElementClass();
    }

    @Override
    @ApiStatus.Internal
    public E instance() {
        try {
            return (E)((SyntaxElement)this.type().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @ApiStatus.Internal
    public @Unmodifiable Collection<String> patterns() {
        return List.of(this.getPatterns());
    }

    @Override
    @ApiStatus.Internal
    public Priority priority() {
        return SyntaxInfo.COMBINED;
    }
}

