/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.patterns;

import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.patterns.ChoicePatternElement;
import ch.njol.skript.patterns.GroupPatternElement;
import ch.njol.skript.patterns.Keyword;
import ch.njol.skript.patterns.MatchResult;
import ch.njol.skript.patterns.OptionalPatternElement;
import ch.njol.skript.patterns.PatternElement;
import ch.njol.skript.patterns.TypePatternElement;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.Nullable;

public class SkriptPattern {
    private final PatternElement first;
    private final int expressionAmount;
    private final Keyword[] keywords;
    @Nullable
    private List<TypePatternElement> types;

    public SkriptPattern(PatternElement first, int expressionAmount) {
        this.first = first;
        this.expressionAmount = expressionAmount;
        this.keywords = Keyword.buildKeywords(first);
    }

    @Nullable
    public MatchResult match(String expr, int flags, ParseContext parseContext) {
        String lowerExpr = expr.toLowerCase(Locale.ENGLISH);
        for (Keyword keyword : this.keywords) {
            if (keyword.isPresent(lowerExpr)) continue;
            return null;
        }
        expr = expr.trim();
        MatchResult matchResult = new MatchResult();
        matchResult.source = this;
        matchResult.expr = expr;
        matchResult.expressions = new Expression[this.expressionAmount];
        matchResult.parseContext = parseContext;
        matchResult.flags = flags;
        return this.first.match(expr, matchResult);
    }

    @Nullable
    public MatchResult match(String expr) {
        return this.match(expr, 3, ParseContext.DEFAULT);
    }

    public String toString() {
        return this.first.toFullString();
    }

    public int countTypes() {
        return this.expressionAmount;
    }

    public int countNonNullTypes() {
        return SkriptPattern.countNonNullTypes(this.first);
    }

    private static int countNonNullTypes(PatternElement patternElement) {
        int count = 0;
        while (patternElement != null) {
            if (patternElement instanceof ChoicePatternElement) {
                int max = 0;
                for (PatternElement component : ((ChoicePatternElement)patternElement).getPatternElements()) {
                    int componentCount = SkriptPattern.countNonNullTypes(component);
                    if (componentCount <= max) continue;
                    max = componentCount;
                }
                count += max;
            } else if (patternElement instanceof GroupPatternElement) {
                count += SkriptPattern.countNonNullTypes(((GroupPatternElement)patternElement).getPatternElement());
            } else if (patternElement instanceof OptionalPatternElement) {
                count += SkriptPattern.countNonNullTypes(((OptionalPatternElement)patternElement).getPatternElement());
            } else if (patternElement instanceof TypePatternElement) {
                ++count;
            }
            patternElement = patternElement.originalNext;
        }
        return count;
    }

    public <T extends PatternElement> List<T> getElements(Class<T> type) {
        if (type == TypePatternElement.class) {
            if (this.types == null) {
                this.types = ImmutableList.copyOf(SkriptPattern.getElements(TypePatternElement.class, this.first, new ArrayList()));
            }
            return this.types;
        }
        return SkriptPattern.getElements(type, this.first, new ArrayList());
    }

    private static <T extends PatternElement> List<T> getElements(Class<T> type, PatternElement element, List<T> elements) {
        while (element != null) {
            if (element instanceof ChoicePatternElement) {
                ((ChoicePatternElement)element).getPatternElements().forEach(e -> SkriptPattern.getElements(type, e, elements));
            } else if (element instanceof GroupPatternElement) {
                SkriptPattern.getElements(type, ((GroupPatternElement)element).getPatternElement(), elements);
            } else if (element instanceof OptionalPatternElement) {
                SkriptPattern.getElements(type, ((OptionalPatternElement)element).getPatternElement(), elements);
            } else if (type.isInstance(element)) {
                elements.add(element);
            }
            element = element.originalNext;
        }
        return elements;
    }
}

