/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.registrations;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.Getter;
import ch.njol.util.Kleenean;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.SetMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;
import org.skriptlang.skript.lang.converter.Converter;
import org.skriptlang.skript.lang.converter.Converters;

public class EventValues {
    public static final int TIME_PAST = -1;
    public static final int TIME_NOW = 0;
    public static final int TIME_FUTURE = 1;
    private static final List<EventValueInfo<?, ?>> defaultEventValues = new ArrayList(30);
    private static final List<EventValueInfo<?, ?>> futureEventValues = new ArrayList();
    private static final List<EventValueInfo<?, ?>> pastEventValues = new ArrayList();

    private EventValues() {
    }

    public static List<EventValueInfo<?, ?>> getEventValuesListForTime(int time) {
        return ImmutableList.copyOf(EventValues.getEventValuesList(time));
    }

    private static List<EventValueInfo<?, ?>> getEventValuesList(int time) {
        if (time == -1) {
            return pastEventValues;
        }
        if (time == 0) {
            return defaultEventValues;
        }
        if (time == 1) {
            return futureEventValues;
        }
        throw new IllegalArgumentException("time must be -1, 0, or 1");
    }

    public static <T, E extends Event> void registerEventValue(Class<E> eventClass, Class<T> valueClass, Converter<E, T> converter) {
        EventValues.registerEventValue(eventClass, valueClass, converter, 0);
    }

    public static <T, E extends Event> void registerEventValue(Class<E> eventClass, Class<T> valueClass, Converter<E, T> converter, int time) {
        EventValues.registerEventValue(eventClass, valueClass, converter, time, null, (Class[])null);
    }

    @SafeVarargs
    public static <T, E extends Event> void registerEventValue(Class<E> eventClass, Class<T> valueClass, Converter<E, T> converter, int time, @Nullable String excludeErrorMessage, Class<? extends E> ... excludes) {
        Skript.checkAcceptRegistrations();
        List<EventValueInfo<?, ?>> eventValues = EventValues.getEventValuesList(time);
        EventValueInfo<? extends E, T> element = new EventValueInfo<E, T>(eventClass, valueClass, converter, excludeErrorMessage, excludes, time);
        for (int i = 0; i < eventValues.size(); ++i) {
            EventValueInfo<?, ?> info = eventValues.get(i);
            if (info.eventClass.equals(eventClass) && info.valueClass.equals(valueClass)) {
                return;
            }
            if (!(!info.eventClass.equals(eventClass) ? info.eventClass.isAssignableFrom(eventClass) : info.valueClass.isAssignableFrom(valueClass))) continue;
            eventValues.add(i, element);
            return;
        }
        eventValues.add(element);
    }

    @Deprecated(since="2.10.0", forRemoval=true)
    @SafeVarargs
    public static <T, E extends Event> void registerEventValue(Class<E> eventClass, Class<T> valueClass, Getter<T, E> getter, int time, @Nullable String excludeErrorMessage, Class<? extends E> ... excludes) {
        EventValues.registerEventValue(eventClass, valueClass, getter, time, excludeErrorMessage, excludes);
    }

    @Deprecated(since="2.10.0", forRemoval=true)
    public static <T, E extends Event> void registerEventValue(Class<E> eventClass, Class<T> valueClass, Getter<T, E> getter, int time) {
        EventValues.registerEventValue(eventClass, valueClass, getter, time);
    }

    @Nullable
    public static <T, E extends Event> T getEventValue(E event, Class<T> valueClass, int time) {
        Converter<?, T> converter = EventValues.getEventValueConverter(event.getClass(), valueClass, time);
        if (converter == null) {
            return null;
        }
        return converter.convert(event);
    }

    @Deprecated(since="2.10.0", forRemoval=true)
    @Nullable
    public static <T, E extends Event> Getter<? extends T, ? super E> getExactEventValueGetter(Class<E> eventClass, Class<T> valueClass, int time) {
        return EventValues.toGetter(EventValues.getExactEventValueConverter(eventClass, valueClass, time));
    }

    @Nullable
    public static <E extends Event, T> Converter<? super E, ? extends T> getExactEventValueConverter(Class<E> eventClass, Class<T> valueClass, int time) {
        List<EventValueInfo<?, ?>> eventValues = EventValues.getEventValuesList(time);
        for (EventValueInfo<?, ?> eventValueInfo : eventValues) {
            if (!valueClass.equals(eventValueInfo.valueClass)) continue;
            if (!EventValues.checkExcludes(eventValueInfo, eventClass)) {
                return null;
            }
            if (!eventValueInfo.eventClass.isAssignableFrom(eventClass)) continue;
            return eventValueInfo.converter;
        }
        return null;
    }

    @Deprecated(since="2.10.0", forRemoval=true)
    public static <T, E extends Event> Kleenean hasMultipleGetters(Class<E> eventClass, Class<T> valueClass, int time) {
        return EventValues.hasMultipleConverters(eventClass, valueClass, time);
    }

    public static <T, E extends Event> Kleenean hasMultipleConverters(Class<E> eventClass, Class<T> valueClass, int time) {
        List<Converter<E, T>> getters = EventValues.getEventValueConverters(eventClass, valueClass, time, true, false);
        if (getters == null) {
            return Kleenean.UNKNOWN;
        }
        return Kleenean.get(getters.size() > 1);
    }

    @Deprecated(since="2.10.0", forRemoval=true)
    @Nullable
    public static <T, E extends Event> Getter<? extends T, ? super E> getEventValueGetter(Class<E> eventClass, Class<T> valueClass, int time) {
        return EventValues.toGetter(EventValues.getEventValueConverter(eventClass, valueClass, time, true));
    }

    @Nullable
    public static <T, E extends Event> Converter<? super E, ? extends T> getEventValueConverter(Class<E> eventClass, Class<T> valueClass, int time) {
        return EventValues.getEventValueConverter(eventClass, valueClass, time, true);
    }

    @Nullable
    private static <T, E extends Event> Converter<? super E, ? extends T> getEventValueConverter(Class<E> eventClass, Class<T> valueClass, int time, boolean allowDefault) {
        List<Converter<E, T>> list = EventValues.getEventValueConverters(eventClass, valueClass, time, allowDefault);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    @Nullable
    private static <T, E extends Event> List<Converter<? super E, ? extends T>> getEventValueConverters(Class<E> eventClass, Class<T> valueClass, int time, boolean allowDefault) {
        return EventValues.getEventValueConverters(eventClass, valueClass, time, allowDefault, true);
    }

    @Nullable
    private static <T, E extends Event> List<Converter<? super E, ? extends T>> getEventValueConverters(Class<E> eventClass, Class<T> valueClass, int time, boolean allowDefault, boolean allowConverting) {
        List<EventValueInfo<?, ?>> eventValues = EventValues.getEventValuesList(time);
        ArrayList<Converter<Converter<Object, Object>, T>> list = new ArrayList<Converter<Converter<Object, Object>, T>>();
        Converter<E, T> exact = EventValues.getExactEventValueConverter(eventClass, valueClass, time);
        if (exact != null) {
            list.add(exact);
            return list;
        }
        HashMap infoConverterMap = new HashMap();
        for (EventValueInfo<?, ?> eventValueInfo : eventValues) {
            if (!valueClass.isAssignableFrom(eventValueInfo.valueClass)) continue;
            if (!EventValues.checkExcludes(eventValueInfo, eventClass)) {
                return null;
            }
            if (eventValueInfo.eventClass.isAssignableFrom(eventClass)) {
                list.add(eventValueInfo.converter);
                infoConverterMap.put(eventValueInfo, eventValueInfo.converter);
                continue;
            }
            if (!eventClass.isAssignableFrom(eventValueInfo.eventClass)) continue;
            Converter<Event, Object> converter = e -> {
                if (!eventValueInfo.eventClass.isInstance(e)) {
                    return null;
                }
                return eventValueInfo.converter.convert(e);
            };
            list.add(converter);
            infoConverterMap.put(eventValueInfo, converter);
        }
        if (!list.isEmpty()) {
            return EventValues.stripConverters(eventClass, valueClass, infoConverterMap, list);
        }
        if (!allowConverting) {
            return null;
        }
        for (EventValueInfo<?, ?> eventValueInfo : eventValues) {
            boolean checkInstanceOf;
            if (!eventValueInfo.valueClass.isAssignableFrom(valueClass)) continue;
            boolean bl = checkInstanceOf = !eventValueInfo.eventClass.isAssignableFrom(eventClass);
            if (checkInstanceOf && !eventClass.isAssignableFrom(eventValueInfo.eventClass)) continue;
            if (!EventValues.checkExcludes(eventValueInfo, eventClass)) {
                return null;
            }
            Converter<Event, Object> converter = e -> {
                if (checkInstanceOf && !eventValueInfo.eventClass.isInstance(e)) {
                    return null;
                }
                Object object = eventValueInfo.converter.convert(e);
                if (valueClass.isInstance(object)) {
                    return object;
                }
                return null;
            };
            list.add(converter);
            infoConverterMap.put(eventValueInfo, converter);
        }
        if (!list.isEmpty()) {
            return EventValues.stripConverters(eventClass, valueClass, infoConverterMap, list);
        }
        for (EventValueInfo<?, ?> eventValueInfo : eventValues) {
            Converter<?, T> converter;
            if (!eventClass.equals(eventValueInfo.eventClass) || (converter = EventValues.getConvertedConverter(eventValueInfo, valueClass, false)) == null) continue;
            if (!EventValues.checkExcludes(eventValueInfo, eventClass)) {
                return null;
            }
            list.add(converter);
        }
        if (!list.isEmpty()) {
            return list;
        }
        for (EventValueInfo<?, ?> eventValueInfo : eventValues) {
            Converter<?, T> converter;
            if (!eventClass.isAssignableFrom(eventValueInfo.eventClass) || (converter = EventValues.getConvertedConverter(eventValueInfo, valueClass, true)) == null) continue;
            if (!EventValues.checkExcludes(eventValueInfo, eventClass)) {
                return null;
            }
            list.add(converter);
        }
        if (!list.isEmpty()) {
            return list;
        }
        if (allowDefault && time != 0) {
            return EventValues.getEventValueConverters(eventClass, valueClass, 0, false);
        }
        return null;
    }

    private static <E extends Event, T> List<Converter<? super E, ? extends T>> stripConverters(Class<E> eventClass, Class<T> valueClass, Map<EventValueInfo<?, ?>, Converter<? super E, ? extends T>> infoConverterMap, List<Converter<? super E, ? extends T>> converters) {
        if (converters.size() == 1) {
            return converters;
        }
        ClassInfo<T> valueClassInfo = Classes.getExactClassInfo(valueClass);
        ArrayList<Converter<Converter<? super E, ? extends T>, T>> stripped = new ArrayList<Converter<Converter<? super E, ? extends T>, T>>();
        for (EventValueInfo<?, ?> eventValueInfo : infoConverterMap.keySet()) {
            ClassInfo thisClassInfo = Classes.getExactClassInfo(eventValueInfo.valueClass);
            if (thisClassInfo != null && !thisClassInfo.equals(valueClassInfo)) continue;
            stripped.add(infoConverterMap.get(eventValueInfo));
        }
        if (stripped.isEmpty()) {
            return converters;
        }
        return stripped;
    }

    private static boolean checkExcludes(EventValueInfo<?, ?> info, Class<? extends Event> eventClass) {
        if (info.excludes == null) {
            return true;
        }
        for (Class clazz : info.excludes) {
            if (!clazz.isAssignableFrom(eventClass)) continue;
            Skript.error(info.excludeErrorMessage);
            return false;
        }
        return true;
    }

    @Nullable
    private static <E extends Event, F, T> Converter<? super E, ? extends T> getConvertedConverter(EventValueInfo<E, F> info, Class<T> valueClass, boolean checkInstanceOf) {
        Converter converter = Converters.getConverter(info.valueClass, valueClass);
        if (converter == null) {
            return null;
        }
        return event -> {
            if (checkInstanceOf && !info.eventClass.isInstance(event)) {
                return null;
            }
            Object f = info.converter.convert(event);
            if (f == null) {
                return null;
            }
            return converter.convert(f);
        };
    }

    @Deprecated(since="2.10.0", forRemoval=true)
    private static <A, B> Getter<B, A> toGetter(final Converter<A, B> converter) {
        if (converter == null) {
            return null;
        }
        return new Getter<B, A>(){

            @Override
            @Nullable
            public B get(A arg) {
                return converter.convert(arg);
            }
        };
    }

    public static boolean doesExactEventValueHaveTimeStates(Class<? extends Event> eventClass, Class<?> valueClass) {
        return EventValues.getExactEventValueConverter(eventClass, valueClass, -1) != null || EventValues.getExactEventValueConverter(eventClass, valueClass, 1) != null;
    }

    public static boolean doesEventValueHaveTimeStates(Class<? extends Event> eventClass, Class<?> valueClass) {
        return EventValues.getEventValueConverter(eventClass, valueClass, -1, false) != null || EventValues.getEventValueConverter(eventClass, valueClass, 1, false) != null;
    }

    public static int[] getTimeStates() {
        return new int[]{-1, 0, 1};
    }

    public static Multimap<Class<? extends Event>, EventValueInfo<?, ?>> getPerEventEventValues() {
        SetMultimap eventValues = MultimapBuilder.hashKeys().hashSetValues().build();
        for (int time : EventValues.getTimeStates()) {
            for (EventValueInfo<?, ?> eventValueInfo : EventValues.getEventValuesListForTime(time)) {
                Collection existing = eventValues.get(eventValueInfo.eventClass);
                existing.add(eventValueInfo);
                eventValues.putAll(eventValueInfo.eventClass, (Iterable)existing);
            }
        }
        return eventValues;
    }

    public record EventValueInfo<E extends Event, T>(Class<E> eventClass, Class<T> valueClass, Converter<E, T> converter, @Nullable String excludeErrorMessage, @Nullable Class<? extends E>[] excludes, int time) {
        public EventValueInfo(Class<E> eventClass, Class<T> valueClass, Converter<E, T> converter, @Nullable String excludeErrorMessage, @Nullable Class<? extends E>[] excludes, int time) {
            assert (eventClass != null);
            assert (valueClass != null);
            assert (converter != null);
        }
    }
}

