/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.util;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.classes.Parser;
import ch.njol.skript.classes.Serializer;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.localization.Language;
import ch.njol.skript.util.PotionDataUtils;
import ch.njol.skript.util.Timespan;
import ch.njol.util.StringUtils;
import ch.njol.yggdrasil.Fields;
import java.io.StreamCorruptedException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.SuspiciousStewMeta;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public abstract class PotionEffectUtils {
    private static final boolean HAS_SUSPICIOUS_META = Skript.classExists("org.bukkit.inventory.meta.SuspiciousStewMeta");
    static final boolean HAS_OLD_POTION_FIELDS = Skript.fieldExists(PotionEffectType.class, "SLOW");
    static final Map<String, PotionEffectType> types = new HashMap<String, PotionEffectType>();
    private static final Map<String, String> names = new HashMap<String, String>();
    private static final boolean HAS_POTION_TYPE_METHOD;

    private PotionEffectUtils() {
    }

    @Nullable
    public static PotionEffectType parseType(String s) {
        return types.get(s.toLowerCase(Locale.ENGLISH));
    }

    @Nullable
    public static PotionEffectType parseByEffectType(PotionEffectType t) {
        for (PotionEffectType value : types.values()) {
            if (!t.equals(value)) continue;
            return value;
        }
        return null;
    }

    public static String toString(PotionEffectType t) {
        return names.get(t.getKey().getKey());
    }

    public static String toString(PotionEffectType t, int flags) {
        return PotionEffectUtils.toString(t);
    }

    public static String toString(PotionEffect potionEffect) {
        StringBuilder builder = new StringBuilder();
        if (potionEffect.isAmbient()) {
            builder.append("ambient ");
        }
        builder.append("potion effect of ");
        builder.append(PotionEffectUtils.toString(potionEffect.getType()));
        builder.append(" of tier ").append(potionEffect.getAmplifier() + 1);
        if (!potionEffect.hasParticles()) {
            builder.append(" without particles");
        }
        builder.append(" for ").append(potionEffect.getDuration() == -1 ? "infinity" : new Timespan(Timespan.TimePeriod.TICK, Math.abs(potionEffect.getDuration())));
        if (!potionEffect.hasIcon()) {
            builder.append(" without icon");
        }
        return builder.toString();
    }

    public static String[] getNames() {
        return names.values().toArray(new String[0]);
    }

    @Deprecated(since="2.8.5", forRemoval=true)
    @Nullable
    public static PotionType checkPotionType(String name) {
        switch (name) {
            case "uncraftable": 
            case "empty": {
                return PotionType.valueOf((String)"uncraftable");
            }
            case "mundane": {
                return PotionType.MUNDANE;
            }
            case "thick": {
                return PotionType.THICK;
            }
            case "night vision": 
            case "darkvision": {
                return PotionType.NIGHT_VISION;
            }
            case "invisibility": {
                return PotionType.INVISIBILITY;
            }
            case "leaping": 
            case "jump boost": {
                return HAS_OLD_POTION_FIELDS ? PotionType.valueOf((String)"JUMP") : PotionType.LEAPING;
            }
            case "fire resistance": 
            case "fire immunity": {
                return PotionType.FIRE_RESISTANCE;
            }
            case "swiftness": 
            case "speed": {
                return HAS_OLD_POTION_FIELDS ? PotionType.valueOf((String)"SPEED") : PotionType.SWIFTNESS;
            }
            case "slowness": {
                return PotionType.SLOWNESS;
            }
            case "water breathing": {
                return PotionType.WATER_BREATHING;
            }
            case "instant health": 
            case "healing": 
            case "health": {
                return HAS_OLD_POTION_FIELDS ? PotionType.valueOf((String)"INSTANT_HEAL") : PotionType.HEALING;
            }
            case "instant damage": 
            case "harming": 
            case "damage": {
                return HAS_OLD_POTION_FIELDS ? PotionType.valueOf((String)"INSTANT_DAMAGE") : PotionType.HARMING;
            }
            case "poison": {
                return PotionType.POISON;
            }
            case "regeneration": 
            case "regen": {
                return HAS_OLD_POTION_FIELDS ? PotionType.valueOf((String)"REGEN") : PotionType.REGENERATION;
            }
            case "strength": {
                return PotionType.STRENGTH;
            }
            case "weakness": {
                return PotionType.WEAKNESS;
            }
            case "luck": {
                return PotionType.LUCK;
            }
        }
        return null;
    }

    @Nullable
    public static PotionType effectToType(PotionEffectType effect) {
        return PotionType.getByEffect((PotionEffectType)effect);
    }

    public static String getPotionName(@Nullable PotionEffectType effect, boolean extended, boolean strong) {
        if (effect == null) {
            return "bottle of water";
        }
        Object s = "";
        if (extended) {
            s = (String)s + "extended";
        } else if (strong) {
            s = (String)s + "strong";
        }
        s = (String)s + " potion of ";
        s = (String)s + PotionEffectUtils.toString(effect);
        return s;
    }

    public static void clearAllEffects(LivingEntity entity) {
        entity.getActivePotionEffects().forEach(potionEffect -> entity.removePotionEffect(potionEffect.getType()));
    }

    public static void addEffects(LivingEntity entity, Object[] effects) {
        for (Object object : effects) {
            PotionEffect effect;
            if (object instanceof PotionEffect) {
                effect = (PotionEffect)object;
            } else {
                if (!(object instanceof PotionEffectType)) continue;
                effect = new PotionEffect((PotionEffectType)object, 300, 0, false);
            }
            entity.addPotionEffect(effect);
        }
    }

    public static void removeEffects(LivingEntity entity, Object[] effects) {
        for (Object object : effects) {
            PotionEffectType effectType;
            if (object instanceof PotionEffect) {
                effectType = ((PotionEffect)object).getType();
            } else {
                if (!(object instanceof PotionEffectType)) continue;
                effectType = (PotionEffectType)object;
            }
            entity.removePotionEffect(effectType);
        }
    }

    public static void clearAllEffects(ItemType itemType) {
        ItemMeta meta = itemType.getItemMeta();
        if (meta instanceof PotionMeta) {
            ((PotionMeta)meta).clearCustomEffects();
        } else if (HAS_SUSPICIOUS_META && meta instanceof SuspiciousStewMeta) {
            ((SuspiciousStewMeta)meta).clearCustomEffects();
        }
        itemType.setItemMeta(meta);
    }

    public static void addEffects(ItemType itemType, Object[] effects) {
        ItemMeta meta = itemType.getItemMeta();
        for (Object object : effects) {
            PotionEffect effect;
            if (object instanceof PotionEffect) {
                effect = (PotionEffect)object;
            } else {
                if (!(object instanceof PotionEffectType)) continue;
                effect = new PotionEffect((PotionEffectType)object, 300, 0, false);
            }
            if (meta instanceof PotionMeta) {
                ((PotionMeta)meta).addCustomEffect(effect, false);
                continue;
            }
            if (!HAS_SUSPICIOUS_META || !(meta instanceof SuspiciousStewMeta)) continue;
            ((SuspiciousStewMeta)meta).addCustomEffect(effect, false);
        }
        itemType.setItemMeta(meta);
    }

    public static void removeEffects(ItemType itemType, Object[] effects) {
        ItemMeta meta = itemType.getItemMeta();
        for (Object object : effects) {
            PotionEffectType effectType;
            if (object instanceof PotionEffect) {
                effectType = ((PotionEffect)object).getType();
            } else {
                if (!(object instanceof PotionEffectType)) continue;
                effectType = (PotionEffectType)object;
            }
            if (meta instanceof PotionMeta) {
                ((PotionMeta)meta).removeCustomEffect(effectType);
                continue;
            }
            if (!HAS_SUSPICIOUS_META || !(meta instanceof SuspiciousStewMeta)) continue;
            ((SuspiciousStewMeta)meta).removeCustomEffect(effectType);
        }
        itemType.setItemMeta(meta);
    }

    public static List<PotionEffect> getEffects(ItemType itemType) {
        ArrayList<PotionEffect> effects = new ArrayList<PotionEffect>();
        ItemMeta meta = itemType.getItemMeta();
        if (meta instanceof PotionMeta) {
            PotionMeta potionMeta = (PotionMeta)meta;
            if (potionMeta.hasCustomEffects()) {
                effects.addAll(potionMeta.getCustomEffects());
            }
            if (HAS_POTION_TYPE_METHOD) {
                if (potionMeta.hasBasePotionType()) {
                    effects.addAll(potionMeta.getBasePotionType().getPotionEffects());
                }
            } else {
                PotionData data = potionMeta.getBasePotionData();
                if (data != null) {
                    effects.addAll(PotionDataUtils.getPotionEffects(data));
                }
            }
        } else if (HAS_SUSPICIOUS_META && meta instanceof SuspiciousStewMeta) {
            effects.addAll(((SuspiciousStewMeta)meta).getCustomEffects());
        }
        return effects;
    }

    @ApiStatus.Internal
    public static ClassInfo<PotionEffectType> getLegacyClassInfo() {
        return new ClassInfo<PotionEffectType>(PotionEffectType.class, "potioneffecttype").user("potion( ?effect)? ?types?").name("Potion Effect Type").description("A potion effect type, e.g. 'strength' or 'swiftness'.").usage(StringUtils.join(PotionEffectUtils.getNames(), ", ")).examples("apply swiftness 5 to the player", "apply potion of speed 2 to the player for 60 seconds", "remove invisibility from the victim").since("").supplier((PotionEffectType[])PotionEffectType.values()).parser(new Parser<PotionEffectType>(){

            @Override
            @Nullable
            public PotionEffectType parse(String string, ParseContext context) {
                return PotionEffectUtils.parseType(string);
            }

            @Override
            public String toString(PotionEffectType potionEffectType, int flags) {
                return PotionEffectUtils.toString(potionEffectType, flags);
            }

            @Override
            public String toVariableNameString(PotionEffectType potionEffectType) {
                return this.toString(potionEffectType, 0);
            }
        }).serializer(new Serializer<PotionEffectType>(){

            @Override
            public Fields serialize(PotionEffectType potionEffectType) {
                Fields f = new Fields();
                f.putObject("name", potionEffectType.getKey().getKey());
                return f;
            }

            @Override
            public boolean canBeInstantiated() {
                return false;
            }

            @Override
            public void deserialize(PotionEffectType o, Fields f) {
                assert (false);
            }

            @Override
            protected PotionEffectType deserialize(Fields fields) throws StreamCorruptedException {
                String name = fields.getObject("name", String.class);
                assert (name != null);
                PotionEffectType t = PotionEffectType.getByName((String)name);
                if (t == null) {
                    throw new StreamCorruptedException("Invalid PotionEffectType " + name);
                }
                return t;
            }

            @Override
            @Nullable
            public PotionEffectType deserialize(String s) {
                return PotionEffectType.getByName((String)s);
            }

            @Override
            public boolean mustSyncDeserialization() {
                return false;
            }
        });
    }

    static {
        Language.addListener(() -> {
            types.clear();
            names.clear();
            for (PotionEffectType potionEffectType : PotionEffectType.values()) {
                String key = potionEffectType.getKey().getKey();
                String[] entries = Language.getList("potion effect types." + key);
                names.put(key, entries[0]);
                for (String entry : entries) {
                    types.put(entry.toLowerCase(Locale.ENGLISH), potionEffectType);
                }
            }
        });
        HAS_POTION_TYPE_METHOD = Skript.methodExists(PotionMeta.class, "hasBasePotionType", new Class[0]);
    }
}

