/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.util.visual;

import ch.njol.skript.localization.Language;
import ch.njol.skript.localization.Noun;
import java.util.Objects;
import java.util.function.BiFunction;
import org.bukkit.Effect;
import org.bukkit.EntityEffect;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.jetbrains.annotations.Nullable;

public class VisualEffectType {
    private static final String LANGUAGE_NODE = "visual effects";
    private final Enum<?> effect;
    private String pattern;
    private Noun name;
    private boolean colorable = false;
    private BiFunction<Object, Location, Object> dataSupplier = (o, location) -> null;

    private VisualEffectType(Enum<?> effect) {
        this.effect = effect;
    }

    public void setColorable() {
        this.colorable = true;
    }

    public boolean isColorable() {
        return this.colorable;
    }

    public void withData(BiFunction<Object, Location, Object> dataSupplier) {
        this.dataSupplier = dataSupplier;
    }

    @Nullable
    public Object getData(Object raw, Location location) {
        return this.dataSupplier.apply(raw, location);
    }

    public String getId() {
        return this.effect.getDeclaringClass().getSimpleName() + "." + this.effect.name();
    }

    public Noun getName() {
        return this.name;
    }

    public String getPattern() {
        return this.pattern;
    }

    public boolean isEffect() {
        return this.effect instanceof Effect;
    }

    public boolean isEntityEffect() {
        return this.effect instanceof EntityEffect;
    }

    public boolean isParticle() {
        return this.effect instanceof Particle;
    }

    public Effect getEffect() {
        if (!this.isEffect()) {
            throw new IllegalStateException();
        }
        return (Effect)this.effect;
    }

    public EntityEffect getEntityEffect() {
        if (!this.isEntityEffect()) {
            throw new IllegalStateException();
        }
        return (EntityEffect)this.effect;
    }

    public Particle getParticle() {
        if (!this.isParticle()) {
            throw new IllegalStateException();
        }
        return (Particle)this.effect;
    }

    @Nullable
    static VisualEffectType of(Enum<?> effect) {
        Objects.requireNonNull(effect);
        VisualEffectType type = new VisualEffectType(effect);
        String node = "visual effects." + type.getId();
        if (!Language.keyExistsDefault(node + ".pattern")) {
            return null;
        }
        String pattern = Language.get(node + ".pattern");
        type.name = new Noun(node + ".name");
        String areaPattern = Language.get_("visual effects.area_expression");
        type.pattern = pattern + " " + (areaPattern != null ? areaPattern : "");
        return type;
    }
}

