/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.util.visual;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.bukkitutil.ItemUtils;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.SyntaxElementInfo;
import ch.njol.skript.localization.Language;
import ch.njol.skript.localization.Noun;
import ch.njol.skript.util.Color;
import ch.njol.skript.util.ColorRGB;
import ch.njol.skript.util.Direction;
import ch.njol.skript.util.SkriptColor;
import ch.njol.skript.util.Timespan;
import ch.njol.skript.util.visual.ParticleOption;
import ch.njol.skript.util.visual.VisualEffect;
import ch.njol.skript.util.visual.VisualEffectType;
import ch.njol.skript.variables.Variables;
import ch.njol.util.StringUtils;
import ch.njol.util.coll.iterator.SingleItemIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.bukkit.Bukkit;
import org.bukkit.Effect;
import org.bukkit.EntityEffect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Vibration;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.Nullable;

public class VisualEffects {
    private static final boolean NEW_EFFECT_DATA = Skript.classExists("org.bukkit.block.data.BlockData");
    private static final boolean SPELL_CLASS_EXISTS = Skript.classExists("org.bukkit.Particle$Spell");
    private static final Map<String, Consumer<VisualEffectType>> effectTypeModifiers = new HashMap<String, Consumer<VisualEffectType>>();
    private static SyntaxElementInfo<VisualEffect> elementInfo;
    private static VisualEffectType[] visualEffectTypes;
    private static final boolean IS_ITEM_CRACK_MATERIAL;

    @Nullable
    public static VisualEffect parse(String s) {
        if (elementInfo == null) {
            return null;
        }
        return SkriptParser.parseStatic(Noun.stripIndefiniteArticle(s), new SingleItemIterator<SyntaxElementInfo<VisualEffect>>(elementInfo), null);
    }

    public static VisualEffectType get(int i) {
        return visualEffectTypes[i];
    }

    public static String getAllNames() {
        ArrayList<Noun> names = new ArrayList<Noun>();
        for (VisualEffectType visualEffectType : visualEffectTypes) {
            names.add(visualEffectType.getName());
        }
        return StringUtils.join(names, ", ");
    }

    private static void generateTypes() {
        ArrayList types = new ArrayList();
        Stream.of(Effect.class, EntityEffect.class, Particle.class).map(Class::getEnumConstants).flatMap(Arrays::stream).map(VisualEffectType::of).filter(Objects::nonNull).forEach(types::add);
        for (VisualEffectType type : types) {
            String id = type.getId();
            if (!effectTypeModifiers.containsKey(id)) continue;
            effectTypeModifiers.get(id).accept(type);
        }
        visualEffectTypes = types.toArray(new VisualEffectType[0]);
        String[] patterns = new String[visualEffectTypes.length];
        for (int i = 0; i < visualEffectTypes.length; ++i) {
            patterns[i] = visualEffectTypes[i].getPattern();
        }
        elementInfo = new SyntaxElementInfo<VisualEffect>(patterns, VisualEffect.class, VisualEffect.class.getName());
    }

    private static void registerColorable(String id) {
        effectTypeModifiers.put(id, VisualEffectType::setColorable);
    }

    private static void registerDataSupplier(String id, BiFunction<Object, Location, Object> dataSupplier) {
        Consumer<VisualEffectType> consumer = type -> type.withData(dataSupplier);
        if (effectTypeModifiers.containsKey(id)) {
            consumer = effectTypeModifiers.get(id).andThen(consumer);
        }
        effectTypeModifiers.put(id, consumer);
    }

    static {
        Variables.yggdrasil.registerSingleClass(VisualEffectType.class, "VisualEffect.NewType");
        Variables.yggdrasil.registerSingleClass(Effect.class, "Bukkit_Effect");
        Variables.yggdrasil.registerSingleClass(EntityEffect.class, "Bukkit_EntityEffect");
        IS_ITEM_CRACK_MATERIAL = Skript.fieldExists(Particle.class, "ITEM_CRACK") && Particle.valueOf((String)"ITEM_CRACK").getDataType() == Material.class;
        Language.addListener(() -> {
            if (visualEffectTypes != null) {
                return;
            }
            VisualEffects.registerDataSupplier("Effect.POTION_BREAK", (raw, location) -> new PotionEffect(raw == null ? PotionEffectType.SPEED : (PotionEffectType)raw, 1, 0));
            VisualEffects.registerDataSupplier("Effect.SMOKE", (raw, location) -> {
                if (raw == null) {
                    return BlockFace.SELF;
                }
                return Direction.getFacing(((Direction)raw).getDirection((Location)location), false);
            });
            BiFunction<Object, Location, Object> blockDataSupplier = (raw, location) -> {
                if (raw instanceof Object[]) {
                    Object[] data = (Object[])raw;
                    Object object = raw = data[0] != null ? data[0] : data[1];
                }
                if (raw == null) {
                    return Bukkit.createBlockData((Material)Material.AIR);
                }
                if (raw instanceof ItemType) {
                    ItemType type = (ItemType)raw;
                    ItemStack random = type.getRandom();
                    return Bukkit.createBlockData((Material)(random != null ? random.getType() : type.getMaterial()));
                }
                return raw;
            };
            VisualEffects.registerDataSupplier("Particle.BLOCK", blockDataSupplier);
            VisualEffects.registerDataSupplier("Particle.BLOCK_CRACK", blockDataSupplier);
            VisualEffects.registerDataSupplier("Particle.BLOCK_DUST", blockDataSupplier);
            VisualEffects.registerDataSupplier("Particle.BLOCK_MARKER", blockDataSupplier);
            VisualEffects.registerDataSupplier("Particle.DUST_PILLAR", blockDataSupplier);
            VisualEffects.registerDataSupplier("Particle.FALLING_DUST", blockDataSupplier);
            SkriptColor defaultColor = SkriptColor.LIGHT_RED;
            BiFunction<Object, Location, Object> dustOptionsSupplier = (raw, location) -> {
                Object[] data = (Object[])raw;
                Color color = data[0] != null ? (Color)data[0] : defaultColor;
                float size = data[1] != null ? ((Float)data[1]).floatValue() : 1.0f;
                return new Particle.DustOptions(color.asBukkitColor(), size);
            };
            VisualEffects.registerDataSupplier("Particle.DUST", dustOptionsSupplier);
            VisualEffects.registerDataSupplier("Particle.REDSTONE", dustOptionsSupplier);
            VisualEffects.registerDataSupplier("Particle.ENTITY_EFFECT", (raw, location) -> {
                if (raw == null) {
                    return defaultColor.asBukkitColor();
                }
                return ((Color)raw).asBukkitColor();
            });
            BiFunction<Object, Location, Object> oldColorSupplier = (raw, location) -> {
                Color color = raw != null ? (Color)raw : defaultColor;
                return new ParticleOption(color, 1.0f);
            };
            VisualEffects.registerColorable("Particle.SPELL_MOB");
            VisualEffects.registerDataSupplier("Particle.SPELL_MOB", oldColorSupplier);
            VisualEffects.registerColorable("Particle.SPELL_MOB_AMBIENT");
            VisualEffects.registerDataSupplier("Particle.SPELL_MOB_AMBIENT", oldColorSupplier);
            BiFunction<Object, Location, Object> itemStackSupplier = (raw, location) -> {
                ItemStack itemStack = null;
                if (raw instanceof ItemType) {
                    itemStack = ((ItemType)raw).getRandom();
                }
                if (itemStack == null || ItemUtils.isAir(itemStack.getType())) {
                    itemStack = new ItemStack(Material.IRON_SWORD);
                }
                if (IS_ITEM_CRACK_MATERIAL) {
                    return itemStack.getType();
                }
                return itemStack;
            };
            VisualEffects.registerDataSupplier("Particle.ITEM", itemStackSupplier);
            VisualEffects.registerDataSupplier("Particle.ITEM_CRACK", itemStackSupplier);
            VisualEffects.registerDataSupplier("Particle.DUST_COLOR_TRANSITION", (raw, location) -> {
                Object[] data = (Object[])raw;
                Color fromColor = data[0] != null ? (Color)data[0] : defaultColor;
                Color toColor = data[1] != null ? (Color)data[1] : defaultColor;
                float size = data[2] != null ? ((Float)data[2]).floatValue() : 1.0f;
                return new Particle.DustTransition(fromColor.asBukkitColor(), toColor.asBukkitColor(), size);
            });
            VisualEffects.registerColorable("Particle.NOTE");
            VisualEffects.registerDataSupplier("Particle.NOTE", (raw, location) -> {
                int colorValue = (int)(((Number)raw).floatValue() * 255.0f);
                ColorRGB color = ColorRGB.fromRGB(colorValue, 0, 0);
                return new ParticleOption(color, 1.0f);
            });
            VisualEffects.registerDataSupplier("Particle.SCULK_CHARGE", (raw, location) -> raw != null ? raw : Integer.valueOf(0));
            VisualEffects.registerDataSupplier("Particle.SHRIEK", (raw, location) -> {
                int delay = 0;
                if (raw instanceof Timespan) {
                    delay = (int)Math.min(Math.max(((Timespan)raw).getAs(Timespan.TimePeriod.TICK), 0L), Integer.MAX_VALUE);
                }
                return delay;
            });
            VisualEffects.registerDataSupplier("Particle.VIBRATION", (raw, location) -> VibrationUtils.buildVibration((Object[])raw, location));
            if (SPELL_CLASS_EXISTS) {
                VisualEffects.registerDataSupplier("Particle.EFFECT", (input, location) -> new Particle.Spell(org.bukkit.Color.WHITE, 1.0f));
                VisualEffects.registerDataSupplier("Particle.INSTANT_EFFECT", (input, location) -> new Particle.Spell(org.bukkit.Color.WHITE, 1.0f));
                VisualEffects.registerDataSupplier("Particle.DRAGON_BREATH", (input, location) -> Float.valueOf(1.0f));
                VisualEffects.registerDataSupplier("Particle.FLASH", (input, location) -> org.bukkit.Color.WHITE);
            }
            VisualEffects.generateTypes();
        });
    }

    private static final class VibrationUtils {
        private VibrationUtils() {
        }

        private static Vibration buildVibration(Object[] data, Location location) {
            Location destination;
            int arrivalTime = -1;
            if (data[1] != null) {
                arrivalTime = (int)Math.min(Math.max(((Timespan)data[1]).getAs(Timespan.TimePeriod.TICK), 0L), Integer.MAX_VALUE);
            }
            if (data[0] instanceof Entity) {
                Entity entity = (Entity)data[0];
                if (arrivalTime == -1) {
                    arrivalTime = (int)(location.distance(entity.getLocation()) / 20.0);
                }
                return new Vibration(location, (Vibration.Destination)new Vibration.Destination.EntityDestination(entity), arrivalTime);
            }
            Location location2 = destination = data[0] != null ? (Location)data[0] : location;
            if (arrivalTime == -1) {
                arrivalTime = (int)(location.distance(destination) / 20.0);
            }
            return new Vibration(location, (Vibration.Destination)new Vibration.Destination.BlockDestination(destination), arrivalTime);
        }
    }
}

