/*
 * Decompiled with CFR 0.152.
 */
package org.skriptlang.skript.bukkit.displays.text;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.entity.Display;
import org.bukkit.entity.TextDisplay;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Text Display Alignment")
@Description(value={"Returns or changes the <a href='#textalignment'>alignment</a> setting of <a href='#display'>text displays</a>."})
@Examples(value={"set text alignment of the last spawned text display to left aligned"})
@Since(value={"2.10"})
public class ExprTextDisplayAlignment
extends SimplePropertyExpression<Display, TextDisplay.TextAlignment> {
    @Override
    @Nullable
    public TextDisplay.TextAlignment convert(Display display) {
        if (display instanceof TextDisplay) {
            TextDisplay textDisplay = (TextDisplay)display;
            return textDisplay.getAlignment();
        }
        return null;
    }

    @Override
    public Class<?> @Nullable [] acceptChange(Changer.ChangeMode mode) {
        return switch (mode) {
            case Changer.ChangeMode.RESET -> CollectionUtils.array(new Class[0]);
            case Changer.ChangeMode.SET -> CollectionUtils.array(TextDisplay.TextAlignment.class);
            default -> null;
        };
    }

    @Override
    public void change(Event event, Object @Nullable [] delta, Changer.ChangeMode mode) {
        TextDisplay.TextAlignment alignment = mode == Changer.ChangeMode.RESET ? TextDisplay.TextAlignment.CENTER : (TextDisplay.TextAlignment)delta[0];
        for (Display display : (Display[])this.getExpr().getArray(event)) {
            if (!(display instanceof TextDisplay)) continue;
            TextDisplay textDisplay = (TextDisplay)display;
            textDisplay.setAlignment(alignment);
        }
    }

    @Override
    public Class<? extends TextDisplay.TextAlignment> getReturnType() {
        return TextDisplay.TextAlignment.class;
    }

    @Override
    protected String getPropertyName() {
        return "text alignment";
    }

    static {
        ExprTextDisplayAlignment.registerDefault(ExprTextDisplayAlignment.class, TextDisplay.TextAlignment.class, "text alignment[s]", "displays");
    }
}

