/*
 * Decompiled with CFR 0.152.
 */
package org.skriptlang.skript.bukkit.fishing.elements;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Events;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerFishEvent;
import org.jetbrains.annotations.Nullable;

@Name(value="Pull In Hooked Entity")
@Description(value={"Pull the hooked entity to the player."})
@Examples(value={"on fishing state of caught entity:", "\tpull in hooked entity"})
@Events(value={"Fishing"})
@Since(value={"2.10"})
public class EffPullHookedEntity
extends Effect {
    @Override
    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (!this.getParser().isCurrentEvent((Class<? extends Event>)PlayerFishEvent.class)) {
            Skript.error("The 'pull in hooked entity' effect can only be used in the fishing event.");
            return false;
        }
        return true;
    }

    @Override
    protected void execute(Event event) {
        if (!(event instanceof PlayerFishEvent)) {
            return;
        }
        PlayerFishEvent fishEvent = (PlayerFishEvent)event;
        fishEvent.getHook().pullHookedEntity();
    }

    @Override
    public String toString(@Nullable Event event, boolean debug) {
        return "pull in hooked entity";
    }

    static {
        Skript.registerEffect(EffPullHookedEntity.class, "(reel|pull) in hook[ed] entity");
    }
}

