/*
 * Decompiled with CFR 0.152.
 */
package org.skriptlang.skript.bukkit.misc.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.simplification.SimplifiedLiteral;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.Nullable;
import org.joml.AxisAngle4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

@Name(value="Rotation Axis/Angle")
@Description(value={"Returns the axis or angle that a quaternion will rotate by/around.", "All quaternions can be represented by a rotation of some amount around some axis, so this expression provides the ability to get that angle/axis."})
@Examples(value={"set {_quaternion} to axisAngle(45, vector(1, 2, 3))", "send rotation axis of {_quaternion} # 1, 2, 3", "send rotation angle of {_quaternion} # 45", "set rotation angle of {_quaternion} to 135", "set rotation axis of {_quaternion} to vector(0, 1, 0)"})
@Since(value={"2.10"})
public class ExprQuaternionAxisAngle
extends SimplePropertyExpression<Quaternionf, Object> {
    private boolean isAxis;
    static final /* synthetic */ boolean $assertionsDisabled;

    @Override
    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.isAxis = parseResult.hasTag("axis");
        return super.init(expressions, matchedPattern, isDelayed, parseResult);
    }

    @Override
    @Nullable
    public Object convert(Quaternionf from) {
        AxisAngle4f axisAngle = new AxisAngle4f();
        axisAngle.set((Quaternionfc)from);
        if (this.isAxis) {
            return new Vector(axisAngle.x, axisAngle.y, axisAngle.z);
        }
        return Float.valueOf((float)((double)(axisAngle.angle * 180.0f) / Math.PI));
    }

    @Override
    public Class<?> @Nullable [] acceptChange(Changer.ChangeMode mode) {
        return switch (mode) {
            case Changer.ChangeMode.ADD, Changer.ChangeMode.SET, Changer.ChangeMode.REMOVE -> {
                if (Changer.ChangerUtils.acceptsChange(this.getExpr(), Changer.ChangeMode.SET, Quaternionf.class)) {
                    yield CollectionUtils.array(this.isAxis ? Vector.class : Number.class);
                }
                yield null;
            }
            default -> null;
        };
    }

    @Override
    public void change(Event event, Object @Nullable [] delta, Changer.ChangeMode mode) {
        Object object;
        if (!$assertionsDisabled && delta == null) {
            throw new AssertionError();
        }
        Object[] quaternions = (Quaternionf[])this.getExpr().getArray(event);
        AxisAngle4f axisAngle = new AxisAngle4f();
        if (this.isAxis && (object = delta[0]) instanceof Vector) {
            Vector vector = (Vector)object;
            for (Object quaternion : quaternions) {
                axisAngle.set((Quaternionfc)quaternion);
                axisAngle.set(axisAngle.angle, (float)vector.getX(), (float)vector.getY(), (float)vector.getZ());
                quaternion.set(axisAngle);
            }
        } else {
            Object object2 = delta[0];
            if (object2 instanceof Number) {
                Number number = (Number)object2;
                float f = (float)((double)(number.floatValue() / 180.0f) * Math.PI);
                for (Object quaternion : quaternions) {
                    axisAngle.set((Quaternionfc)quaternion);
                    axisAngle.set(f, axisAngle.x, axisAngle.y, axisAngle.z);
                    quaternion.set(axisAngle);
                }
            }
        }
        this.getExpr().change(event, quaternions, Changer.ChangeMode.SET);
    }

    @Override
    public Class<?> getReturnType() {
        return this.isAxis ? Vector.class : Float.class;
    }

    @Override
    public Expression<?> simplify() {
        if (this.getExpr() instanceof Literal) {
            return SimplifiedLiteral.fromExpression(this);
        }
        return this;
    }

    @Override
    protected String getPropertyName() {
        return this.isAxis ? "axis" : "angle";
    }

    static {
        boolean bl = $assertionsDisabled = !ExprQuaternionAxisAngle.class.desiredAssertionStatus();
        if (Skript.classExists("org.joml.Quaternionf")) {
            ExprQuaternionAxisAngle.register(ExprQuaternionAxisAngle.class, Object.class, "rotation (angle|:axis)", "quaternions");
        }
    }
}

