/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.lang.function;

import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.KeyProviderExpression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.function.FunctionReference;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.util.Utils;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.commons.lang3.ArrayUtils;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.skriptlang.skript.lang.converter.Converters;

public class ExprFunctionCall<T>
extends SimpleExpression<T>
implements KeyProviderExpression<T> {
    private final FunctionReference<?> function;
    private final Class<? extends T>[] returnTypes;
    private final Class<T> returnType;
    private final Map<Event, String[]> cache = new WeakHashMap<Event, String[]>();

    public ExprFunctionCall(FunctionReference<T> function) {
        this(function, function.returnTypes);
    }

    public ExprFunctionCall(FunctionReference<?> function, Class<? extends T>[] expectedReturnTypes) {
        this.function = function;
        Class<?> functionReturnType = function.getReturnType();
        assert (functionReturnType != null);
        if (CollectionUtils.containsSuperclass(expectedReturnTypes, functionReturnType)) {
            this.returnTypes = new Class[]{functionReturnType};
            this.returnType = functionReturnType;
        } else {
            this.returnTypes = expectedReturnTypes;
            this.returnType = Utils.getSuperType(expectedReturnTypes);
        }
    }

    @Override
    protected T @Nullable [] get(Event event) {
        ?[] values = this.function.execute(event);
        Object[] keys = this.function.returnedKeys();
        this.function.resetReturnValue();
        Object[] convertedValues = (Object[])Array.newInstance(this.returnType, values != null ? values.length : 0);
        if (values == null || values.length == 0) {
            this.cache.put(event, new String[0]);
            return convertedValues;
        }
        Converters.convert(values, convertedValues, this.returnTypes);
        if (keys != null) {
            for (int i = 0; i < convertedValues.length; ++i) {
                if (convertedValues[i] != null) continue;
                keys[i] = null;
            }
            convertedValues = ArrayUtils.removeAllOccurrences((Object[])convertedValues, null);
            this.cache.put(event, (String[])ArrayUtils.removeAllOccurrences((Object[])keys, null));
        } else {
            convertedValues = ArrayUtils.removeAllOccurrences((Object[])convertedValues, null);
            this.cache.put(event, ExprFunctionCall.generateNumericalKeys(convertedValues.length));
        }
        return convertedValues;
    }

    @Override
    @NotNull
    public @NotNull String @NotNull [] getArrayKeys(Event event) throws IllegalStateException {
        if (!this.cache.containsKey(event)) {
            throw new IllegalStateException();
        }
        return this.cache.remove(event);
    }

    @Override
    public boolean areKeysRecommended() {
        return false;
    }

    @Override
    @Nullable
    public <R> Expression<? extends R> getConvertedExpression(Class<R> ... to) {
        if (CollectionUtils.containsSuperclass(to, this.getReturnType())) {
            return this;
        }
        assert (this.function.getReturnType() != null);
        if (Converters.converterExists(this.function.getReturnType(), to)) {
            return new ExprFunctionCall<R>(this.function, to);
        }
        return null;
    }

    @Override
    public boolean isSingle() {
        return this.function.isSingle();
    }

    @Override
    public Class<? extends T> getReturnType() {
        return this.returnType;
    }

    @Override
    public Class<? extends T>[] possibleReturnTypes() {
        return Arrays.copyOf(this.returnTypes, this.returnTypes.length);
    }

    @Override
    public boolean isLoopOf(String input) {
        return KeyProviderExpression.super.isLoopOf(input);
    }

    @Override
    public String toString(@Nullable Event event, boolean debug) {
        return this.function.toString(event, debug);
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        assert (false);
        return false;
    }

    private static String[] generateNumericalKeys(int length) {
        String[] keys = new String[length];
        for (int i = 0; i < length; ++i) {
            keys[i] = String.valueOf(i);
        }
        return keys;
    }
}

