/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.lang.function;

import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.KeyProviderExpression;
import ch.njol.skript.lang.KeyedValue;
import ch.njol.skript.lang.ReturnHandler;
import ch.njol.skript.lang.Trigger;
import ch.njol.skript.lang.function.Function;
import ch.njol.skript.lang.function.FunctionEvent;
import ch.njol.skript.lang.function.Functions;
import ch.njol.skript.lang.function.Parameter;
import ch.njol.skript.lang.function.Signature;
import ch.njol.skript.lang.parser.ParserInstance;
import ch.njol.skript.lang.util.SimpleEvent;
import ch.njol.skript.variables.HintManager;
import ch.njol.skript.variables.Variables;
import java.util.Arrays;
import org.bukkit.event.Event;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.skriptlang.skript.lang.script.Script;

public class ScriptFunction<T>
extends Function<T>
implements ReturnHandler<T> {
    private final Trigger trigger;
    private boolean returnValueSet;
    private T @Nullable [] returnValues;
    private String @Nullable [] returnKeys;

    @Deprecated(since="2.9.0", forRemoval=true)
    public ScriptFunction(Signature<T> sign, Script script, SectionNode node) {
        this(sign, node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScriptFunction(Signature<T> sign, SectionNode node) {
        super(sign);
        Functions.currentFunction = this;
        HintManager hintManager = ParserInstance.get().getHintManager();
        try {
            hintManager.enterScope(false);
            for (Parameter<?> parameter : sign.getParameters()) {
                Object hintName = parameter.name();
                if (!parameter.isSingleValue()) {
                    hintName = (String)hintName + "::*";
                }
                hintManager.set((String)hintName, parameter.type());
            }
            this.trigger = this.loadReturnableTrigger(node, "function " + sign.getName(), new SimpleEvent());
        }
        finally {
            hintManager.exitScope();
            Functions.currentFunction = null;
        }
        this.trigger.setLineNumber(node.getLine());
    }

    @Override
    public T @Nullable [] execute(FunctionEvent<?> event, Object[][] params) {
        Parameter<?>[] parameters = this.getSignature().getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            Parameter<?> parameter = parameters[i];
            Object[] val = params[i];
            if (parameter.single && val.length > 0) {
                Variables.setVariable(parameter.name, val[0], event, true);
                continue;
            }
            boolean keyed = Arrays.stream(val).allMatch(it -> it instanceof KeyedValue);
            if (keyed) {
                for (Object value : val) {
                    KeyedValue keyedValue = (KeyedValue)value;
                    Variables.setVariable(parameter.name + "::" + keyedValue.key(), keyedValue.value(), event, true);
                }
                continue;
            }
            int count = 0;
            for (Object value : val) {
                Variables.setVariable(parameter.name + "::" + count, value, event, true);
                ++count;
            }
        }
        this.trigger.execute(event);
        ClassInfo returnType = this.getReturnType();
        return returnType != null ? this.returnValues : null;
    }

    @Override
    public @NotNull String @Nullable [] returnedKeys() {
        return this.returnKeys;
    }

    @Deprecated(since="2.9.0", forRemoval=true)
    @ApiStatus.Internal
    public final void setReturnValue(@Nullable T[] values) {
        assert (!this.returnValueSet);
        this.returnValueSet = true;
        this.returnValues = values;
    }

    @Override
    public boolean resetReturnValue() {
        this.returnValueSet = false;
        this.returnValues = null;
        this.returnKeys = null;
        return true;
    }

    @Override
    public final void returnValues(Event event, Expression<? extends T> value) {
        assert (!this.returnValueSet);
        this.returnValueSet = true;
        this.returnValues = value.getArray(event);
        if (KeyProviderExpression.canReturnKeys(value)) {
            this.returnKeys = ((KeyProviderExpression)value).getArrayKeys(event);
        }
    }

    @Override
    public final boolean isSingleReturnValue() {
        return this.isSingle();
    }

    @Override
    @Nullable
    public final Class<? extends T> returnValueType() {
        return this.getReturnType() != null ? this.getReturnType().getC() : null;
    }
}

