/*
 * Decompiled with CFR 0.152.
 */
package org.skriptlang.skript.bukkit.displays.text;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.Math2;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.entity.Display;
import org.bukkit.entity.TextDisplay;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Text Display Opacity")
@Description(value={"Returns or changes the opacity of <a href='#display'>text displays</a>.", "Values are between -127 and 127. The value of 127 represents it being completely opaque."})
@Examples(value={"set the opacity of the last spawned text display to -1 # Reset"})
@Since(value={"2.10"})
public class ExprTextDisplayOpacity
extends SimplePropertyExpression<Display, Byte> {
    @Override
    @Nullable
    public Byte convert(Display display) {
        if (display instanceof TextDisplay) {
            TextDisplay textDisplay = (TextDisplay)display;
            return textDisplay.getTextOpacity();
        }
        return null;
    }

    @Override
    public Class<?> @Nullable [] acceptChange(Changer.ChangeMode mode) {
        return switch (mode) {
            case Changer.ChangeMode.ADD, Changer.ChangeMode.REMOVE, Changer.ChangeMode.RESET, Changer.ChangeMode.SET -> CollectionUtils.array(Number.class);
            default -> null;
        };
    }

    @Override
    public void change(Event event, Object @Nullable [] delta, Changer.ChangeMode mode) {
        Display[] displays = (Display[])this.getExpr().getArray(event);
        int change = delta == null ? -1 : ((Number)delta[0]).intValue();
        switch (mode) {
            case REMOVE: 
            case REMOVE_ALL: {
                change = -change;
            }
            case ADD: {
                for (Display display : displays) {
                    if (!(display instanceof TextDisplay)) continue;
                    TextDisplay textDisplay = (TextDisplay)display;
                    byte value = (byte)Math2.fit(-127, textDisplay.getTextOpacity() + change, 127);
                    textDisplay.setTextOpacity(value);
                }
                break;
            }
            case RESET: 
            case SET: 
            case DELETE: {
                change = Math2.fit(-127, change, 127);
                for (Display display : displays) {
                    if (!(display instanceof TextDisplay)) continue;
                    TextDisplay textDisplay = (TextDisplay)display;
                    textDisplay.setTextOpacity((byte)change);
                }
                break;
            }
        }
    }

    @Override
    public Class<? extends Byte> getReturnType() {
        return Byte.class;
    }

    @Override
    protected String getPropertyName() {
        return "opacity";
    }

    static {
        ExprTextDisplayOpacity.registerDefault(ExprTextDisplayOpacity.class, Byte.class, "[display] opacity", "displays");
    }
}

